/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component.sequence;

import icy.gui.component.sequence.SequenceChooser;
import icy.gui.component.sequence.SequencePreviewPanel;
import icy.sequence.AbstractSequenceModel;
import icy.sequence.Sequence;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SequenceChooserPreviewPanel
extends JPanel
implements SequenceChooser.SequenceChooserListener {
    private static final long serialVersionUID = -1637532468722270264L;
    protected JLabel titleLabel;
    protected SequenceChooser sequenceChooser;
    SequencePreviewPanel sequencePreviewPanel;

    public SequenceChooserPreviewPanel(String title) {
        this.initialize(title);
        this.sequenceChanged(this.sequenceChooser.getSelectedSequence());
        this.sequencePreviewPanel.setModel(new SequenceChooserPreviewModel());
        this.sequenceChooser.addListener(this);
    }

    public SequenceChooserPreviewPanel() {
        this((String)null);
    }

    private void initialize(String title) {
        this.setLayout(new BorderLayout(0, 0));
        this.sequencePreviewPanel = new SequencePreviewPanel();
        this.sequencePreviewPanel.setBorder(new EmptyBorder(4, 0, 0, 0));
        this.add((Component)this.sequencePreviewPanel, "Center");
        JPanel panel = new JPanel();
        this.add((Component)panel, "North");
        panel.setLayout(new BorderLayout(0, 0));
        this.sequenceChooser = new SequenceChooser();
        panel.add(this.sequenceChooser);
        if (!StringUtil.isEmpty(title)) {
            this.titleLabel = new JLabel(title);
            this.titleLabel.setBorder(new EmptyBorder(4, 0, 0, 8));
            panel.add((Component)this.titleLabel, "West");
        }
    }

    public SequenceChooser getSequenceChooser() {
        return this.sequenceChooser;
    }

    public SequencePreviewPanel getSequencePreviewPanel() {
        return this.sequencePreviewPanel;
    }

    public boolean getPreviewVisible() {
        return this.sequencePreviewPanel.isVisible();
    }

    public void setPreviewVisible(boolean value) {
        this.sequencePreviewPanel.setVisible(value);
    }

    public void setTitle(String value) {
        this.sequencePreviewPanel.setTitle(value);
    }

    @Override
    public void sequenceChanged(Sequence sequence) {
        this.sequencePreviewPanel.dimensionChanged();
    }

    public void dimensionChanged() {
        this.sequencePreviewPanel.dimensionChanged();
    }

    public void imageChanged() {
        this.sequencePreviewPanel.imageChanged();
    }

    private class SequenceChooserPreviewModel
    extends AbstractSequenceModel {
        @Override
        public int getSizeX() {
            Sequence sequence = SequenceChooserPreviewPanel.this.sequenceChooser.getSelectedSequence();
            if (sequence != null) {
                return sequence.getSizeX();
            }
            return 0;
        }

        @Override
        public int getSizeY() {
            Sequence sequence = SequenceChooserPreviewPanel.this.sequenceChooser.getSelectedSequence();
            if (sequence != null) {
                return sequence.getSizeY();
            }
            return 0;
        }

        @Override
        public int getSizeZ() {
            Sequence sequence = SequenceChooserPreviewPanel.this.sequenceChooser.getSelectedSequence();
            if (sequence != null) {
                return sequence.getSizeZ();
            }
            return 0;
        }

        @Override
        public int getSizeT() {
            Sequence sequence = SequenceChooserPreviewPanel.this.sequenceChooser.getSelectedSequence();
            if (sequence != null) {
                return sequence.getSizeT();
            }
            return 0;
        }

        @Override
        public int getSizeC() {
            Sequence sequence = SequenceChooserPreviewPanel.this.sequenceChooser.getSelectedSequence();
            if (sequence != null) {
                return sequence.getSizeC();
            }
            return 0;
        }

        @Override
        public BufferedImage getImage(int t, int z) {
            Sequence sequence = SequenceChooserPreviewPanel.this.sequenceChooser.getSelectedSequence();
            if (sequence != null) {
                return sequence.getImage(t, z);
            }
            return null;
        }

        @Override
        public BufferedImage getImage(int t, int z, int c) {
            Sequence sequence = SequenceChooserPreviewPanel.this.sequenceChooser.getSelectedSequence();
            if (sequence != null) {
                return sequence.getImage(t, z, c);
            }
            return null;
        }
    }
}

