/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.dialog;

import icy.gui.main.MainFrame;
import icy.main.Icy;
import icy.system.thread.ThreadUtil;
import java.awt.Component;
import javax.swing.JOptionPane;

public class ConfirmDialog {
    public static final int DEFAULT_OPTION = 1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;

    public static boolean getBooleanReturnValue(int returnValue) {
        return returnValue == 0 || returnValue == 0;
    }

    public static int confirmEx(String title, String message, int optionType) {
        Confirmer confirmer = new Confirmer(title, message, optionType);
        ThreadUtil.invokeNow(confirmer);
        return confirmer.intResult;
    }

    public static boolean confirm(String title, String message, int optionType) {
        Confirmer confirmer = new Confirmer(title, message, optionType);
        ThreadUtil.invokeNow(confirmer);
        return confirmer.result;
    }

    public static boolean confirm(String message) {
        return ConfirmDialog.confirm("Confirmation", message, 0);
    }

    public static boolean confirm(String title, String message) {
        return ConfirmDialog.confirm(title, message, 0);
    }

    private static class Confirmer
    implements Runnable {
        private final String title;
        private final String message;
        private final int optionType;
        int intResult;
        boolean result;

        public Confirmer(String title, String message, int optionType) {
            this.title = title;
            this.message = message;
            this.optionType = optionType;
        }

        @Override
        public void run() {
            if (Icy.getMainInterface().isHeadLess()) {
                this.result = true;
            } else {
                MainFrame parent = Icy.getMainInterface().getMainFrame();
                this.intResult = JOptionPane.showConfirmDialog((Component)((Object)parent), this.message, this.title, this.optionType, 3);
                this.result = ConfirmDialog.getBooleanReturnValue(this.intResult);
            }
        }
    }
}

