/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.frame;

import icy.action.IcyAbstractAction;
import icy.common.MenuCallback;
import icy.gui.util.LookAndFeelUtil;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.pushingpixels.substance.internal.utils.SubstanceInternalFrameTitlePane;

public class IcyInternalFrame
extends JInternalFrame {
    private static final long serialVersionUID = -5445569637723054083L;
    SubstanceInternalFrameTitlePane titlePane = null;
    MenuCallback systemMenuCallback;
    private boolean titleBarVisible;
    private boolean closeItemVisible;
    private boolean initialized = false;

    public IcyInternalFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        super(title, resizable, closable, maximizable, iconifiable);
        this.addPropertyChangeListener("titlePane", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ThreadUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IcyInternalFrame.this.updateTitlePane();
                    }
                });
            }
        });
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                IcyInternalFrame.this.systemMenuCallback = null;
            }
        });
        this.setFrameIcon(ResourceUtil.ICON_ICY_16);
        this.setVisible(false);
        this.systemMenuCallback = null;
        this.closeItemVisible = closable;
        this.updateTitlePane(LookAndFeelUtil.getTitlePane(this));
        this.titleBarVisible = true;
        this.initialized = true;
    }

    protected void updateTitlePane(SubstanceInternalFrameTitlePane pane) {
        if (pane != null) {
            this.titlePane = pane;
        }
        this.updateSystemMenu();
    }

    protected void updateTitlePane() {
        if (this.initialized) {
            this.updateTitlePane(LookAndFeelUtil.getTitlePane(this));
            if (!this.titleBarVisible) {
                this.setTitleBarVisible(false);
            }
        }
    }

    public void updateSystemMenu() {
        if (this.titlePane != null && !this.isClosed()) {
            JMenu menu = this.systemMenuCallback != null ? this.systemMenuCallback.getMenu() : this.getDefaultSystemMenu();
            menu.getPopupMenu().setLightWeightPopupEnabled(false);
            this.titlePane.setSystemMenu(menu);
        }
    }

    public void close(boolean force) {
        if (force || this.isClosable()) {
            this.doDefaultCloseAction();
        }
    }

    public boolean isMinimized() {
        return this.isIcon();
    }

    public boolean isMaximized() {
        return this.isMaximum();
    }

    public void setMinimized(boolean value) {
        if (this.isMinimized() ^ value) {
            try {
                this.setIcon(value);
            }
            catch (PropertyVetoException e) {
                IcyExceptionHandler.showErrorMessage(e, true);
            }
        }
    }

    public void setMaximized(boolean value) {
        if (this.getParent() == null) {
            return;
        }
        if (this.isMaximized() ^ value) {
            try {
                this.setMaximum(value);
            }
            catch (PropertyVetoException e) {
                IcyExceptionHandler.showErrorMessage(e, true);
            }
        }
    }

    public boolean isTitleBarVisible() {
        return this.titleBarVisible;
    }

    public boolean isCloseItemVisible() {
        return this.closeItemVisible;
    }

    public void setCloseItemVisible(boolean value) {
        if (this.closeItemVisible != value) {
            this.closeItemVisible = value;
            ThreadUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IcyInternalFrame.this.updateSystemMenu();
                }
            });
        }
    }

    @Override
    public void setClosable(boolean b) {
        super.setClosable(b);
        if (!b) {
            this.setCloseItemVisible(false);
        }
    }

    public void setTitleBarVisible(boolean value) {
        if (value) {
            LookAndFeelUtil.setTitlePane(this, this.titlePane);
        } else {
            LookAndFeelUtil.setTitlePane(this, null);
        }
        this.revalidate();
        this.titleBarVisible = value;
    }

    public JMenu getDefaultSystemMenu() {
        JMenu result = new JMenu();
        if (this.closeItemVisible) {
            result.add(new CloseAction());
        }
        return result;
    }

    public MenuCallback getSystemMenuCallback() {
        return this.systemMenuCallback;
    }

    public void setSystemMenuCallback(MenuCallback value) {
        if (this.systemMenuCallback != value) {
            this.systemMenuCallback = value;
            ThreadUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IcyInternalFrame.this.updateSystemMenu();
                }
            });
        }
    }

    private class CloseAction
    extends IcyAbstractAction {
        private static final long serialVersionUID = 4933605299188863452L;

        public CloseAction() {
            super("Close", new IcyIcon(ResourceUtil.ICON_CLOSE, 20), "Close window", 115, SystemUtil.getMenuCtrlMask());
        }

        @Override
        public boolean doAction(ActionEvent e) {
            IcyInternalFrame.this.close(false);
            return true;
        }
    }
}

