/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.frame.progress;

import icy.common.listener.ProgressListener;
import icy.gui.frame.progress.TaskFrame;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JProgressBar;

public class ProgressFrame
extends TaskFrame
implements ProgressListener,
Runnable {
    JProgressBar progressBar;
    protected double length = 100.0;
    protected double position = -1.0;
    protected String message;
    protected String tooltip;

    public ProgressFrame(final String message) {
        super("");
        this.message = message;
        if (this.headless) {
            return;
        }
        ThreadUtil.invokeLater(new Runnable(){
            final /* synthetic */ ProgressFrame this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.progressBar = new JProgressBar();
                this.this$0.progressBar.setString(this.this$0.buildMessage(message));
                this.this$0.progressBar.setStringPainted(true);
                this.this$0.progressBar.setIndeterminate(true);
                this.this$0.progressBar.setBorder(BorderFactory.createEmptyBorder());
                this.this$0.progressBar.setMinimum(0);
                this.this$0.progressBar.setMaximum(1000);
                this.this$0.mainPanel.setLayout(new BorderLayout());
                this.this$0.mainPanel.add((Component)this.this$0.progressBar, "Center");
                this.this$0.pack();
            }
        });
    }

    protected String buildMessage(String message) {
        return "  " + message + "  ";
    }

    @Override
    public void run() {
        ThreadUtil.sleep(10);
        this.updateDisplay();
    }

    public void refresh() {
        ThreadUtil.runSingle(this);
    }

    protected void updateDisplay() {
        if (this.headless) {
            return;
        }
        ThreadUtil.invokeNow(new Runnable(){

            @Override
            public void run() {
                if (ProgressFrame.this.position != -1.0 && ProgressFrame.this.length > 0.0) {
                    if (ProgressFrame.this.progressBar.isIndeterminate()) {
                        ProgressFrame.this.progressBar.setIndeterminate(false);
                    }
                    int value = (int)(ProgressFrame.this.position * 1000.0 / ProgressFrame.this.length);
                    if (ProgressFrame.this.progressBar.getValue() != value) {
                        ProgressFrame.this.progressBar.setValue(value);
                    }
                } else if (!ProgressFrame.this.progressBar.isIndeterminate()) {
                    ProgressFrame.this.progressBar.setIndeterminate(true);
                }
                String text = ProgressFrame.this.buildMessage(ProgressFrame.this.message);
                if (!StringUtil.equals(ProgressFrame.this.progressBar.getString(), text)) {
                    ProgressFrame.this.progressBar.setString(text);
                    ProgressFrame.this.progressBar.invalidate();
                    ProgressFrame.this.pack();
                }
                if (!StringUtil.equals(ProgressFrame.this.progressBar.getToolTipText(), ProgressFrame.this.tooltip)) {
                    ProgressFrame.this.progressBar.setToolTipText(ProgressFrame.this.tooltip);
                }
            }
        });
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String value) {
        if (this.message != value) {
            this.message = value;
            this.refresh();
        }
    }

    @Override
    public void setToolTipText(String value) {
        if (this.tooltip != value) {
            this.tooltip = value;
            this.refresh();
        }
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double value) {
        if (this.length != value) {
            this.length = value;
            this.refresh();
        }
    }

    public double getPosition() {
        return this.position;
    }

    public void incPosition() {
        this.setPosition(this.position + 1.0);
    }

    public void setPosition(double value) {
        if (this.position != value) {
            this.position = value;
            this.refresh();
        }
    }

    @Deprecated
    public void setProgress(int value) {
        this.setPosition(value);
    }

    @Override
    public boolean notifyProgress(double position, double length) {
        this.setPosition(position);
        this.setLength(length);
        return true;
    }
}

