/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.inspector;

import icy.gui.component.ExtTabbedPanel;
import icy.gui.component.ExternalizablePanel;
import icy.gui.component.button.IcyToggleButton;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.gui.inspector.LayersPanel;
import icy.gui.inspector.RoisPanel;
import icy.gui.inspector.SequencePanel;
import icy.gui.inspector.UndoManagerPanel;
import icy.gui.main.ActiveSequenceListener;
import icy.gui.main.ActiveViewerListener;
import icy.gui.main.MainFrame;
import icy.gui.system.MemoryMonitorPanel;
import icy.gui.system.OutputConsolePanel;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.image.cache.ImageCache;
import icy.main.Icy;
import icy.preferences.ApplicationPreferences;
import icy.preferences.GeneralPreferences;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InspectorPanel
extends ExternalizablePanel
implements ActiveViewerListener,
ActiveSequenceListener {
    private static final long serialVersionUID = 5538230736731006318L;
    final ExtTabbedPanel mainPane = new ExtTabbedPanel();
    final SequencePanel sequencePanel;
    final RoisPanel roisPanel;
    final LayersPanel layersPanel;
    final UndoManagerPanel historyPanel;
    final OutputConsolePanel outputConsolePanel;
    final IcyToggleButton virtualModeBtn;

    public InspectorPanel() {
        super("Inspector", "inspector", new Point(600, 140), new Dimension(300, 600));
        this.mainPane.setTabLayoutPolicy(1);
        this.sequencePanel = new SequencePanel();
        this.roisPanel = new RoisPanel();
        this.layersPanel = new LayersPanel();
        this.historyPanel = new UndoManagerPanel();
        this.outputConsolePanel = new OutputConsolePanel();
        this.virtualModeBtn = new IcyToggleButton(new IcyIcon(ResourceUtil.ICON_HDD_STREAM, 48));
        this.virtualModeBtn.setToolTipText("Enable / disable the virtual mode (all images are created in virtual mode)");
        this.virtualModeBtn.setHideActionText(true);
        this.virtualModeBtn.setFlat(true);
        this.virtualModeBtn.setFocusable(false);
        this.virtualModeBtn.setSelected(GeneralPreferences.getVirtualMode());
        this.virtualModeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectorPanel.this.setVirtualModeInternal(!GeneralPreferences.getVirtualMode());
            }
        });
        this.mainPane.addTab("Sequence", null, new JScrollPane(this.sequencePanel, 20, 31), "Sequence informations");
        this.mainPane.addTab("ROI", null, this.roisPanel, "Manage / edit your ROI");
        this.mainPane.addTab("Layer", null, this.layersPanel, "Show all layers details");
        this.mainPane.addTab("History", null, this.historyPanel, "Actions history");
        this.mainPane.addTab("Output", null, this.outputConsolePanel, "Console output");
        Dimension minDim = new Dimension(300, 480);
        this.getFrame().setMinimumSizeInternal(minDim);
        this.getFrame().setMinimumSizeExternal(minDim);
        this.setMinimumSize(minDim);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPane, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)this.virtualModeBtn, "East");
        bottomPanel.add((Component)new MemoryMonitorPanel(), "Center");
        this.add((Component)bottomPanel, "South");
        this.validate();
        this.setVisible(true);
        final Color defaultBgColor = this.mainPane.getBackgroundAt(0);
        this.mainPane.addChangeListener(new ChangeListener(){
            final /* synthetic */ InspectorPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = this.this$0.getIndexOfTab(this.this$0.outputConsolePanel);
                if (index != -1 && this.this$0.mainPane.getSelectedIndex() == index) {
                    this.this$0.mainPane.setBackgroundAt(index, defaultBgColor);
                }
            }
        });
        this.outputConsolePanel.addOutputConsoleChangeListener(new OutputConsolePanel.OutputConsoleChangeListener(){

            @Override
            public void outputConsoleChanged(OutputConsolePanel source, boolean isError) {
                final int index = InspectorPanel.this.getIndexOfTab(InspectorPanel.this.outputConsolePanel);
                if (index != -1 && InspectorPanel.this.mainPane.getSelectedIndex() != index) {
                    final boolean fIsError = isError;
                    ThreadUtil.invokeLater(new Runnable(){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            if (fIsError) {
                                this.this$1.InspectorPanel.this.mainPane.setBackgroundAt(index, Color.red);
                            } else if (!this.this$1.InspectorPanel.this.mainPane.getBackgroundAt(index).equals(Color.red)) {
                                this.this$1.InspectorPanel.this.mainPane.setBackgroundAt(index, Color.blue);
                            }
                        }
                    });
                }
            }
        });
        Icy.getMainInterface().addActiveViewerListener(this);
        Icy.getMainInterface().addActiveSequenceListener(this);
    }

    public ExtTabbedPanel getMainPane() {
        return this.mainPane;
    }

    public SequencePanel getSequencePanel() {
        return this.sequencePanel;
    }

    public RoisPanel getRoisPanel() {
        return this.roisPanel;
    }

    public LayersPanel getLayersPanel() {
        return this.layersPanel;
    }

    public UndoManagerPanel getHistoryPanel() {
        return this.historyPanel;
    }

    public OutputConsolePanel getOutputConsolePanel() {
        return this.outputConsolePanel;
    }

    public static boolean getVirtualMode() {
        return GeneralPreferences.getVirtualMode();
    }

    public void setVirtualMode(boolean value) {
        this.virtualModeBtn.setSelected(value);
        this.setVirtualModeInternal(value);
    }

    boolean setVirtualModeInternal(boolean value) {
        boolean ok = false;
        try {
            ok = value ? ImageCache.init(ApplicationPreferences.getCacheMemoryMB(), ApplicationPreferences.getCachePath()) : ImageCache.shutDownIfEmpty();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        if (!ok) {
            if (!value) {
                new FailedAnnounceFrame("Cannot disable Image cache now. Some open images or sequences are using it.");
            }
            this.virtualModeBtn.setSelected(!value);
            return false;
        }
        GeneralPreferences.setVirtualMode(value);
        for (Viewer viewer : Icy.getMainInterface().getViewers()) {
            viewer.refreshToolBar();
        }
        MainFrame mainFrame = Icy.getMainInterface().getMainFrame();
        if (mainFrame != null) {
            mainFrame.refreshTitle();
        }
        return true;
    }

    public void imageCacheDisabled() {
        this.setVirtualMode(false);
        this.virtualModeBtn.setEnabled(false);
        this.virtualModeBtn.setToolTipText("Image cache is disabled, cannot use the virtual mode");
    }

    protected int getIndexOfTab(Component component) {
        return this.mainPane.indexOfComponent(component);
    }

    @Override
    public void viewerActivated(Viewer viewer) {
        this.sequencePanel.viewerActivated(viewer);
        this.layersPanel.viewerActivated(viewer);
    }

    @Override
    public void viewerDeactivated(Viewer viewer) {
    }

    @Override
    public void activeViewerChanged(ViewerEvent event) {
        this.sequencePanel.activeViewerChanged(event);
        this.layersPanel.activeViewerChanged(event);
    }

    @Override
    public void sequenceActivated(Sequence sequence) {
        this.sequencePanel.sequenceActivated(sequence);
        this.roisPanel.sequenceActivated(sequence);
        this.historyPanel.sequenceActivated(sequence);
    }

    @Override
    public void sequenceDeactivated(Sequence sequence) {
    }

    @Override
    public void activeSequenceChanged(SequenceEvent event) {
        this.sequencePanel.activeSequenceChanged(event);
        this.roisPanel.activeSequenceChanged(event);
    }
}

