/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.menu.search;

import icy.gui.menu.search.SearchBar;
import icy.gui.menu.search.SearchProducerTableCellRenderer;
import icy.gui.menu.search.SearchResultTableCellRenderer;
import icy.gui.menu.search.SearchResultTableModel;
import icy.main.Icy;
import icy.search.SearchEngine;
import icy.search.SearchResult;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.internal.ui.common.JRichTooltipPanel;

public class SearchResultPanel
extends JWindow
implements ListSelectionListener {
    private static final long serialVersionUID = -7794681892496197765L;
    private static final int ROW_HEIGHT = 48;
    private static final int MAX_ROW = 15;
    final SearchBar searchBar;
    JRichTooltipPanel tooltipPanel;
    Popup tooltip;
    SearchResult toolTipResult;
    boolean toolTipForceRefresh;
    final SearchResultTableModel tableModel;
    final JTable table;
    final JScrollPane scrollPane;
    private final Runnable refresher;
    private final Runnable toolTipRefresher;

    public SearchResultPanel(SearchBar sb) {
        super((Frame)((Object)Icy.getMainInterface().getMainFrame()));
        this.searchBar = sb;
        this.tooltipPanel = null;
        this.tooltip = null;
        this.toolTipResult = null;
        this.toolTipForceRefresh = false;
        this.refresher = new Runnable(){

            @Override
            public void run() {
                SearchResultPanel.this.refreshInternal();
            }
        };
        this.toolTipRefresher = new Runnable(){

            @Override
            public void run() {
                SearchResultPanel.this.updateToolTip();
            }
        };
        this.tableModel = new SearchResultTableModel(-1);
        this.table = new JTable(this.tableModel);
        TableColumnModel colModel = this.table.getColumnModel();
        TableColumn col = colModel.getColumn(0);
        col.setCellRenderer((TableCellRenderer)((Object)new SearchProducerTableCellRenderer()));
        col.setPreferredWidth(140);
        col = colModel.getColumn(1);
        col.setCellRenderer((TableCellRenderer)((Object)new SearchResultTableCellRenderer()));
        col.setPreferredWidth(600);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setShowVerticalLines(false);
        this.table.setShowHorizontalLines(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setTableHeader(null);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SearchResult result = SearchResultPanel.this.getResultAtPosition(e.getPoint());
                if (result != null && result.isEnabled()) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        result.execute();
                    } else {
                        result.executeAlternate();
                    }
                    SearchResultPanel.this.close(true);
                    e.consume();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SearchResultPanel.this.table.getSelectionModel().removeSelectionInterval(0, SearchResultPanel.this.table.getRowCount() - 1);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                int row = SearchResultPanel.this.table.rowAtPoint(e.getPoint());
                if (row != -1) {
                    SearchResultPanel.this.table.getSelectionModel().setSelectionInterval(row, row);
                } else {
                    SearchResultPanel.this.table.getSelectionModel().removeSelectionInterval(0, SearchResultPanel.this.table.getRowCount() - 1);
                }
            }
        });
        this.table.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = SearchResultPanel.this.table.rowAtPoint(e.getPoint());
                if (row != -1) {
                    SearchResultPanel.this.table.getSelectionModel().setSelectionInterval(row, row);
                } else {
                    SearchResultPanel.this.table.getSelectionModel().removeSelectionInterval(0, SearchResultPanel.this.table.getRowCount() - 1);
                }
            }
        });
        this.scrollPane = new JScrollPane(this.table, 20, 31);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.setPreferredSize(new Dimension(600, 400));
        this.setAlwaysOnTop(true);
        this.setVisible(false);
    }

    protected SearchEngine getSearchEngine() {
        return this.searchBar.getSearchEngine();
    }

    protected SearchResult getResult(int index) {
        if (index >= 0 && index < this.table.getRowCount()) {
            return (SearchResult)this.table.getValueAt(index, 1);
        }
        return null;
    }

    protected int getRowIndex(SearchResult result) {
        if (result != null) {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                if (result != this.table.getValueAt(i, 1)) continue;
                return i;
            }
        }
        return -1;
    }

    protected SearchResult getResultAtPosition(Point pt) {
        return this.getResult(this.table.rowAtPoint(pt));
    }

    public SearchResult getSelectedResult() {
        return this.getResult(this.table.getSelectedRow());
    }

    public void setSelectedResult(SearchResult result) {
        int row = this.getRowIndex(result);
        if (row != -1) {
            this.table.getSelectionModel().setSelectionInterval(row, row);
        } else {
            this.table.getSelectionModel().removeSelectionInterval(0, this.table.getRowCount() - 1);
        }
    }

    void hideToolTip() {
        if (this.tooltip != null) {
            this.tooltip.hide();
            this.tooltip = null;
            this.toolTipResult = null;
        }
    }

    int getPanelHeight() {
        Insets margin = this.getInsets();
        Insets marginSC = this.scrollPane.getInsets();
        Insets marginT = this.table.getInsets();
        int result = Math.min(this.table.getRowCount(), 15) * 48;
        return result += margin.top + margin.bottom + (marginSC.top + marginSC.bottom) + (marginT.top + marginT.bottom);
    }

    void updateToolTip() {
        final SearchResult searchResult = this.getSelectedResult();
        ThreadUtil.invokeNow(new Runnable(){
            final /* synthetic */ SearchResultPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (!this.this$0.isVisible() || searchResult == null) {
                    this.this$0.hideToolTip();
                    return;
                }
                RichTooltip rtp = searchResult.getRichToolTip();
                if (rtp == null) {
                    this.this$0.hideToolTip();
                    return;
                }
                if (this.this$0.tooltip == null || searchResult != this.this$0.toolTipResult || this.this$0.toolTipForceRefresh) {
                    this.this$0.hideToolTip();
                    Rectangle bounds = this.this$0.getBounds();
                    this.this$0.tooltipPanel = new JRichTooltipPanel(rtp);
                    int x = bounds.x + bounds.width;
                    int y = bounds.y + 48 * this.this$0.table.getSelectedRow();
                    this.this$0.tooltip = PopupFactory.getSharedInstance().getPopup((Component)((Object)Icy.getMainInterface().getMainFrame()), (Component)this.this$0.tooltipPanel, x, y -= this.this$0.scrollPane.getVerticalScrollBar().getValue());
                    this.this$0.tooltip.show();
                    this.this$0.toolTipResult = searchResult;
                    this.this$0.toolTipForceRefresh = false;
                }
            }
        });
    }

    public void close(boolean reset) {
        if (reset) {
            this.searchBar.cancelSearch();
        }
        this.setVisible(false);
        this.hideToolTip();
    }

    public void executeSelected() {
        SearchResult sr = this.getSelectedResult();
        if (sr != null && sr.isEnabled()) {
            sr.execute();
            this.close(true);
        }
    }

    public void refresh() {
        ThreadUtil.runSingle(this.refresher);
    }

    void refreshInternal() {
        SearchResult selected;
        int resultCount;
        List<SearchResult> results;
        SearchEngine searchEngine = this.getSearchEngine();
        if (searchEngine.getLastSearch().isEmpty()) {
            results = new ArrayList<SearchResult>();
            resultCount = 0;
            selected = null;
        } else {
            results = searchEngine.getResults();
            resultCount = results.size();
            selected = this.getSelectedResult();
        }
        ThreadUtil.sleep(1);
        ThreadUtil.invokeNow(new Runnable(){
            final /* synthetic */ SearchResultPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (resultCount == 0) {
                    this.this$0.close(false);
                    return;
                }
                this.this$0.table.setRowHeight(48);
                this.this$0.tableModel.setResults(results);
                this.this$0.tableModel.fireTableDataChanged();
                this.this$0.setSelectedResult(selected);
                Point p = this.this$0.searchBar.getLocationOnScreen();
                this.this$0.setBounds(p.x, p.y + this.this$0.searchBar.getHeight(), 600, this.this$0.getPanelHeight());
                this.this$0.setVisible(true);
                this.this$0.updateToolTip();
            }
        });
    }

    public void moveSelection(int direction) {
        int rowCount = this.table.getRowCount();
        if (rowCount == 0) {
            return;
        }
        int rowIndex = this.table.getSelectedRow();
        int newIndex = rowIndex == -1 ? (direction > 0 ? 0 : rowCount - 1) : Math.abs((rowIndex + direction) % rowCount);
        this.table.setRowSelectionInterval(newIndex, newIndex);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ThreadUtil.runSingle(this.toolTipRefresher);
    }

    public void resultChanged(SearchResult result) {
        if (this.isVisible()) {
            try {
                int rowIndex = this.getRowIndex(result);
                if (rowIndex != -1) {
                    this.tableModel.fireTableRowsUpdated(rowIndex, rowIndex);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == this.getSelectedResult()) {
                this.toolTipForceRefresh = true;
                ThreadUtil.runSingle(this.toolTipRefresher);
            }
        }
    }

    public void resultsChanged() {
        this.refresh();
    }
}

