/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.preferences;

import icy.gui.preferences.PreferenceFrame;
import icy.gui.preferences.WorkspaceListPreferencePanel;
import icy.preferences.WorkspaceLocalPreferences;
import icy.workspace.Workspace;
import icy.workspace.WorkspaceInstaller;
import icy.workspace.WorkspaceLoader;
import java.util.ArrayList;
import java.util.List;

public class WorkspaceLocalPreferencePanel
extends WorkspaceListPreferencePanel
implements WorkspaceLoader.WorkspaceLoaderListener,
WorkspaceInstaller.WorkspaceInstallerListener {
    private static final long serialVersionUID = -7178443947421949836L;
    public static final String NODE_NAME = "Local Workspace";
    private ArrayList<String> activesWorkspace;

    WorkspaceLocalPreferencePanel(PreferenceFrame parent) {
        super(parent, NODE_NAME);
        this.action1Button.setText("Delete");
        this.action1Button.setVisible(true);
        this.refreshWorkspaces();
        WorkspaceLoader.addListener(this);
        WorkspaceInstaller.addListener(this);
    }

    @Override
    protected void closed() {
        super.closed();
        WorkspaceLoader.removeListener(this);
        WorkspaceInstaller.removeListener(this);
    }

    @Override
    protected int getColumnCount() {
        return 4;
    }

    @Override
    protected void doAction1(Workspace workspace) {
        WorkspaceInstaller.desinstall(workspace, true);
        this.refreshTableData();
        this.updateButtonsState();
    }

    @Override
    protected Boolean isWorkspaceEnable(Workspace workspace) {
        return this.activesWorkspace.contains(workspace.getName());
    }

    @Override
    protected void setWorkspaceEnable(Workspace workspace, Boolean value) {
        String name = workspace.getName();
        if (value.booleanValue()) {
            if (!this.activesWorkspace.contains(name)) {
                this.activesWorkspace.add(name);
            }
        } else {
            this.activesWorkspace.remove(name);
        }
    }

    private void cleanActivesWorkspace(List<Workspace> workspaces) {
        for (int i = this.activesWorkspace.size() - 1; i >= 0; --i) {
            String name = this.activesWorkspace.get(i);
            if (Workspace.getWorkspace(workspaces, name) != null) continue;
            this.activesWorkspace.remove(i);
        }
    }

    @Override
    protected void load() {
        super.load();
        this.activesWorkspace = WorkspaceLocalPreferences.getActivesWorkspace();
    }

    @Override
    protected void save() {
        WorkspaceLocalPreferences.setActivesWorkspace(this.activesWorkspace);
        super.save();
    }

    @Override
    protected void repositoryChanged() {
    }

    @Override
    protected void reloadWorkspaces() {
        WorkspaceLoader.reloadAsynch();
        this.refreshWorkspaces();
    }

    @Override
    protected String getStateValue(Workspace workspace) {
        if (workspace == null) {
            return "";
        }
        if (WorkspaceInstaller.isDesinstallingWorkspace(workspace)) {
            return "Deleting...";
        }
        return "";
    }

    @Override
    protected List<Workspace> getWorkspaces() {
        ArrayList<Workspace> result;
        if (WorkspaceLoader.isLoading()) {
            result = new ArrayList();
        } else {
            result = WorkspaceLoader.getWorkspaces();
            Workspace.removeWorkspace(result, "sys");
            this.cleanActivesWorkspace(result);
        }
        return result;
    }

    @Override
    protected void updateButtonsStateInternal() {
        if (WorkspaceLoader.isLoading()) {
            this.refreshButton.setText("Reloading...");
            this.refreshButton.setEnabled(false);
        } else {
            this.refreshButton.setText("Reload list");
            this.refreshButton.setEnabled(true);
        }
        Workspace workspace = this.getSelectedWorkspace();
        if (workspace == null) {
            this.action1Button.setText("Delete");
            this.action1Button.setEnabled(false);
            return;
        }
        if (WorkspaceInstaller.isDesinstallingWorkspace(workspace)) {
            this.action1Button.setText("Deleting...");
            this.action1Button.setEnabled(false);
        } else {
            this.action1Button.setText("Delete");
            this.action1Button.setEnabled(true);
        }
    }

    @Override
    public void workspaceLoaderChanged(WorkspaceLoader.WorkspaceLoaderEvent e) {
        this.workspacesChanged();
    }

    @Override
    public void workspaceInstalled(WorkspaceInstaller.WorkspaceInstallerEvent e) {
        Workspace workspace = e.getWorkspace();
        this.setWorkspaceEnable(workspace, Boolean.TRUE);
        this.getPreferenceFrame().setNeedRestart();
        this.updateButtonsState();
    }

    @Override
    public void workspaceRemoved(WorkspaceInstaller.WorkspaceInstallerEvent e) {
        this.getPreferenceFrame().setNeedRestart();
        this.updateButtonsState();
    }
}

