/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.sequence;

import icy.gui.dialog.ActionDialog;
import icy.gui.dialog.MessageDialog;
import icy.gui.sequence.SequencePropertiesPanel;
import icy.main.Icy;
import icy.math.UnitUtil;
import icy.sequence.Sequence;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SequencePropertiesDialog
extends ActionDialog {
    private static final long serialVersionUID = 5696186054980120411L;
    SequencePropertiesPanel panel;

    public SequencePropertiesDialog(final Sequence sequence) {
        super("Sequence Properties");
        this.initialize();
        this.panel.setSequence(sequence);
        this.setCloseAfterAction(false);
        this.setOkAction(new ActionListener(){
            final /* synthetic */ SequencePropertiesDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                double sx = this.this$0.panel.getPixelSizeXFieldValue();
                double sy = this.this$0.panel.getPixelSizeYFieldValue();
                double sz = this.this$0.panel.getPixelSizeZFieldValue();
                double st = this.this$0.panel.getTimeIntervalFieldValue();
                if (sx <= 0.0 || sy <= 0.0 || sz <= 0.0) {
                    MessageDialog.showDialog("Pixel size values should be > 0 !", 2);
                    return;
                }
                sequence.setName(this.this$0.panel.getNameFieldValue());
                sequence.setPixelSizeX(UnitUtil.getValueInUnit(sx, this.this$0.panel.getPixelSizeXUnit(), UnitUtil.UnitPrefix.MICRO));
                sequence.setPixelSizeY(UnitUtil.getValueInUnit(sy, this.this$0.panel.getPixelSizeYUnit(), UnitUtil.UnitPrefix.MICRO));
                sequence.setPixelSizeZ(UnitUtil.getValueInUnit(sz, this.this$0.panel.getPixelSizeZUnit(), UnitUtil.UnitPrefix.MICRO));
                double valueInSec = st;
                switch (this.this$0.panel.getTimeIntervalUnit()) {
                    case 0: {
                        valueInSec *= 60.0;
                    }
                    case 1: {
                        valueInSec *= 60.0;
                        break;
                    }
                    case 3: {
                        valueInSec /= 1000.0;
                    }
                }
                sequence.setTimeInterval(valueInSec);
                sequence.setPositionX(UnitUtil.getValueInUnit(this.this$0.panel.getPositionXValue(), this.this$0.panel.getPositionXUnit(), UnitUtil.UnitPrefix.MICRO));
                sequence.setPositionY(UnitUtil.getValueInUnit(this.this$0.panel.getPositionYValue(), this.this$0.panel.getPositionYUnit(), UnitUtil.UnitPrefix.MICRO));
                sequence.setPositionZ(UnitUtil.getValueInUnit(this.this$0.panel.getPositionZValue(), this.this$0.panel.getPositionZUnit(), UnitUtil.UnitPrefix.MICRO));
                for (int c = 0; c < sequence.getSizeC(); ++c) {
                    sequence.setChannelName(c, this.this$0.panel.getChannelNameFieldValue(c));
                }
                this.this$0.dispose();
            }
        });
        this.pack();
        this.setLocationRelativeTo((Component)((Object)Icy.getMainInterface().getMainFrame()));
        this.setVisible(true);
    }

    private void initialize() {
        this.panel = new SequencePropertiesPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.panel, "Center");
        this.mainPanel.validate();
    }
}

