/*
 * Decompiled with CFR 0.152.
 */
package icy.image;

import icy.image.ImagePosition;

public class ChannelPosition
extends ImagePosition {
    public static final char C_ID_0 = 'C';
    public static final char C_ID_1 = 'W';
    protected int c;

    public ChannelPosition(int t, int z, int c) {
        super(t, z);
        this.c = c;
    }

    public ChannelPosition(ChannelPosition cp) {
        this(cp.t, cp.z, cp.c);
    }

    public ChannelPosition() {
        this(-1, -1, -1);
    }

    public void copyFrom(ChannelPosition cp) {
        this.t = cp.t;
        this.z = cp.z;
        this.c = cp.c;
    }

    @Override
    public void switchLeft() {
        this.t = this.z;
        this.z = this.c;
        this.c = 0;
    }

    @Override
    public void switchRight() {
        this.c = this.z;
        this.z = this.t;
        this.t = 0;
    }

    public int getC() {
        return this.c;
    }

    public void setC(int c) {
        this.c = c;
    }

    public void set(int t, int z, int c) {
        super.set(t, z);
        this.c = c;
    }

    @Override
    public int get(char ident) {
        char id = Character.toUpperCase(ident);
        switch (id) {
            case 'C': 
            case 'W': {
                return this.c;
            }
        }
        return super.get(ident);
    }

    public static boolean isValidIdentStatic(char ident) {
        char id = Character.toUpperCase(ident);
        return ImagePosition.isValidIdentStatic(ident) || id == 'C' || id == 'W';
    }

    @Override
    public boolean isValidIdent(char ident) {
        return ChannelPosition.isValidIdentStatic(ident);
    }

    public boolean isCUndefined() {
        return this.c == -1;
    }

    @Override
    public boolean isUndefined() {
        return this.isCUndefined() || super.isUndefined();
    }

    public char getAlternateFirstEmptyPos() {
        if (this.isCUndefined()) {
            return 'C';
        }
        return super.getFirstEmptyPos();
    }

    @Override
    public char getFirstEmptyPos() {
        char result = super.getFirstEmptyPos();
        if (result == ' ' && this.isCUndefined()) {
            return 'C';
        }
        return result;
    }

    public char getAlternateLastEmptyPos() {
        char result = super.getLastEmptyPos();
        if (result == ' ' && this.isCUndefined()) {
            return 'C';
        }
        return result;
    }

    @Override
    public char getLastEmptyPos() {
        if (this.isCUndefined()) {
            return 'C';
        }
        return super.getLastEmptyPos();
    }

    public boolean isSamePos(ChannelPosition cp, char posIdent) {
        char id = Character.toUpperCase(posIdent);
        switch (id) {
            case 'C': 
            case 'W': {
                if (this.t == -1 || this.z == -1 || this.c == -1) {
                    return false;
                }
                return cp.t == this.t && cp.z == this.z && cp.c == this.c;
            }
        }
        return super.isSamePos(cp, posIdent);
    }

    @Override
    public int compareTo(ImagePosition o) {
        int result = super.compareTo(o);
        if (result == 0 && o instanceof ChannelPosition) {
            int cp = ((ChannelPosition)o).c;
            if (this.c > cp) {
                return 1;
            }
            if (this.c < cp) {
                return -1;
            }
        }
        return result;
    }

    public int alternateCompareTo(ChannelPosition cp) {
        int oc = cp.c;
        if (this.c > oc) {
            return 1;
        }
        if (this.c < oc) {
            return -1;
        }
        return super.compareTo(cp);
    }
}

