/*
 * Decompiled with CFR 0.152.
 */
package icy.image.lut;

import icy.common.CollapsibleEvent;
import icy.image.lut.LUT;

public class LUTEvent
implements CollapsibleEvent {
    private final LUT lut;
    private final LUTEventType type;
    private int component;

    public LUTEvent(LUT lut, int component, LUTEventType type) {
        this.lut = lut;
        this.component = component;
        this.type = type;
    }

    public LUT getLut() {
        return this.lut;
    }

    public int getComponent() {
        return this.component;
    }

    public LUTEventType getType() {
        return this.type;
    }

    @Override
    public boolean collapse(CollapsibleEvent event) {
        if (this.equals(event)) {
            LUTEvent e = (LUTEvent)event;
            if (e.getComponent() != this.component) {
                this.component = -1;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.lut.hashCode() ^ this.type.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LUTEvent) {
            LUTEvent e = (LUTEvent)obj;
            return this.lut == e.getLut() && this.type == e.getType();
        }
        return super.equals(obj);
    }

    public static enum LUTEventType {
        SCALER_CHANGED,
        COLORMAP_CHANGED;

    }
}

