/*
 * Decompiled with CFR 0.152.
 */
package icy.network;

import icy.preferences.XMLPreferences;
import icy.util.StringUtil;

public class AuthenticationInfo {
    private static final String ID_LOGIN = "login";
    private static final String ID_PASSWORD = "password";
    private static final String ID_ENABLED = "enabled";
    private String login;
    private String password;
    private boolean enabled;

    public AuthenticationInfo(String login, String password, boolean enabled) {
        this.login = login;
        this.password = password;
        this.enabled = enabled;
    }

    public AuthenticationInfo(XMLPreferences node) {
        this("", "", false);
        this.load(node);
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void save(XMLPreferences node) {
        if (node != null) {
            node.put(ID_LOGIN, this.login);
            node.put(ID_PASSWORD, this.password);
            node.putBoolean(ID_ENABLED, this.enabled);
        }
    }

    public void load(XMLPreferences node) {
        if (node != null) {
            this.login = node.get(ID_LOGIN, "");
            this.password = node.get(ID_PASSWORD, "");
            this.enabled = node.getBoolean(ID_ENABLED, false);
        }
    }

    public int hashCode() {
        return this.login.hashCode() ^ this.password.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AuthenticationInfo) {
            AuthenticationInfo auth = (AuthenticationInfo)obj;
            return StringUtil.equals(auth.login, this.login) && StringUtil.equals(auth.password, this.password);
        }
        return super.equals(obj);
    }
}

