/*
 * Decompiled with CFR 0.152.
 */
package icy.painter;

import icy.canvas.IcyCanvas;
import icy.common.CollapsibleEvent;
import icy.common.UpdateEventHandler;
import icy.common.listener.ChangeListener;
import icy.file.xml.XMLPersistent;
import icy.gui.viewer.Viewer;
import icy.main.Icy;
import icy.painter.OverlayEvent;
import icy.painter.OverlayListener;
import icy.painter.Painter;
import icy.sequence.Sequence;
import icy.system.IcyExceptionHandler;
import icy.type.point.Point5D;
import icy.util.ClassUtil;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Overlay
implements Painter,
ChangeListener,
Comparable<Overlay>,
XMLPersistent {
    public static final String ID_OVERLAY = "overlay";
    public static final String ID_CLASSNAME = "classname";
    public static final String ID_ID = "id";
    public static final String ID_NAME = "name";
    public static final String ID_PRIORITY = "priority";
    public static final String ID_READONLY = "readOnly";
    public static final String ID_CANBEREMOVED = "canBeRemoved";
    public static final String ID_RECEIVEKEYEVENTONHIDDEN = "receiveKeyEventOnHidden";
    public static final String ID_RECEIVEMOUSEEVENTONHIDDEN = "receiveMouseEventOnHidden";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_PRIORITY = "priority";
    public static final String PROPERTY_READONLY = "readOnly";
    public static final String PROPERTY_PERSISTENT = "persitent";
    public static final String PROPERTY_CANBEREMOVED = "canBeRemoved";
    public static final String PROPERTY_RECEIVEKEYEVENTONHIDDEN = "receiveKeyEventOnHidden";
    public static final String PROPERTY_RECEIVEMOUSEEVENTONHIDDEN = "receiveMouseEventOnHidden";
    public static final int LOD_SMALL = 10;
    public static final int LOD_TINY = 4;
    protected static int id_gen = 1;
    protected int id;
    protected String name;
    protected OverlayPriority priority;
    protected boolean persistent;
    protected boolean readOnly;
    protected boolean canBeRemoved;
    protected boolean receiveKeyEventOnHidden;
    protected boolean receiveMouseEventOnHidden;
    protected final List<OverlayListener> listeners;
    protected final UpdateEventHandler updater;

    public static Overlay createFromXML(Node node) {
        if (node == null) {
            return null;
        }
        String className = XMLUtil.getElementValue(node, ID_CLASSNAME, "");
        if (StringUtil.isEmpty(className)) {
            return null;
        }
        try {
            Class<?> clazz = ClassUtil.findClass(className);
            if (clazz != null) {
                Class<Overlay> overlayClazz = clazz.asSubclass(Overlay.class);
                Constructor<Overlay> constructor = overlayClazz.getConstructor(new Class[0]);
                Overlay result = constructor.newInstance(new Object[0]);
                if (result != null && !result.loadFromXML(node)) {
                    return null;
                }
                return result;
            }
        }
        catch (NoSuchMethodException e) {
            IcyExceptionHandler.handleException(new NoSuchMethodException("Default constructor not found in class '" + className + "', cannot create the Overlay."), true);
        }
        catch (ClassNotFoundException e) {
            IcyExceptionHandler.handleException(new ClassNotFoundException("Cannot find '" + className + "' class, cannot create the Overlay."), true);
        }
        catch (Exception e) {
            IcyExceptionHandler.handleException(e, true);
        }
        return null;
    }

    public static int getOverlayCount(Node node) {
        ArrayList<Node> nodesOverlay;
        if (node != null && (nodesOverlay = XMLUtil.getChildren(node, ID_OVERLAY)) != null) {
            return nodesOverlay.size();
        }
        return 0;
    }

    public static List<Overlay> loadOverlaysFromXML(Node node) {
        ArrayList<Node> nodesOverlay;
        ArrayList<Overlay> result = new ArrayList<Overlay>();
        if (node != null && (nodesOverlay = XMLUtil.getChildren(node, ID_OVERLAY)) != null) {
            for (Node n : nodesOverlay) {
                Overlay overlay = Overlay.createFromXML(n);
                if (overlay == null) continue;
                overlay.setPersistent(true);
                result.add(overlay);
            }
        }
        return result;
    }

    public static void saveOverlaysToXML(Node node, List<Overlay> overlays) {
        if (node != null) {
            for (Overlay overlay : overlays) {
                Element nodeOverlay;
                if (!overlay.isPersistent() || overlay.saveToXML(nodeOverlay = XMLUtil.addElement(node, ID_OVERLAY))) continue;
                XMLUtil.removeNode(node, nodeOverlay);
                System.err.println("Error: the overlay " + overlay.getName() + " was not correctly saved to XML !");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Overlay(String name, OverlayPriority priority) {
        Class<Overlay> clazz = Overlay.class;
        synchronized (Overlay.class) {
            this.id = id_gen++;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.name = name;
            this.priority = priority;
            this.persistent = false;
            this.readOnly = false;
            this.canBeRemoved = true;
            this.receiveKeyEventOnHidden = false;
            this.receiveMouseEventOnHidden = false;
            this.listeners = new ArrayList<OverlayListener>();
            this.updater = new UpdateEventHandler(this, false);
            return;
        }
    }

    public Overlay(String name) {
        this(name, OverlayPriority.SHAPE_NORMAL);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name != name) {
            this.name = name;
            this.propertyChanged("name");
        }
    }

    public OverlayPriority getPriority() {
        return this.priority;
    }

    public void setPriority(OverlayPriority priority) {
        if (this.priority != priority) {
            this.priority = priority;
            this.propertyChanged("priority");
        }
    }

    public boolean isAttached(Sequence sequence) {
        if (sequence != null) {
            return sequence.contains(this);
        }
        return false;
    }

    @Deprecated
    public boolean isFixed() {
        return !this.getCanBeRemoved();
    }

    @Deprecated
    public void setFixed(boolean value) {
        this.setCanBeRemoved(!value);
    }

    public boolean getCanBeRemoved() {
        return this.canBeRemoved;
    }

    public void setCanBeRemoved(boolean value) {
        if (this.canBeRemoved != value) {
            this.canBeRemoved = value;
            this.propertyChanged("canBeRemoved");
        }
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean value) {
        if (this.persistent != value) {
            this.persistent = value;
            this.propertyChanged(PROPERTY_PERSISTENT);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean value) {
        if (this.readOnly != value) {
            this.readOnly = value;
            this.propertyChanged("readOnly");
        }
    }

    public boolean getReceiveKeyEventOnHidden() {
        return this.receiveKeyEventOnHidden;
    }

    public void setReceiveKeyEventOnHidden(boolean value) {
        if (this.receiveKeyEventOnHidden != value) {
            this.receiveKeyEventOnHidden = value;
            this.propertyChanged("receiveKeyEventOnHidden");
        }
    }

    public boolean getReceiveMouseEventOnHidden() {
        return this.receiveMouseEventOnHidden;
    }

    public void setReceiveMouseEventOnHidden(boolean value) {
        if (this.receiveMouseEventOnHidden != value) {
            this.receiveMouseEventOnHidden = value;
            this.propertyChanged("receiveMouseEventOnHidden");
        }
    }

    public JPanel getOptionsPanel() {
        return null;
    }

    @Deprecated
    public void attachTo(Sequence sequence) {
        if (sequence != null) {
            sequence.addOverlay(this);
        }
    }

    @Deprecated
    public void detachFrom(Sequence sequence) {
        if (sequence != null) {
            sequence.removeOverlay(this);
        }
    }

    public void remove() {
        for (Sequence sequence : this.getSequences()) {
            sequence.removeOverlay(this);
        }
        for (IcyCanvas canvas : this.getAttachedCanvas()) {
            canvas.removeLayer(this);
        }
    }

    public List<Sequence> getSequences() {
        return Icy.getMainInterface().getSequencesContaining(this);
    }

    public List<IcyCanvas> getAttachedCanvas() {
        ArrayList<IcyCanvas> result = new ArrayList<IcyCanvas>();
        for (Viewer viewer : Icy.getMainInterface().getViewers()) {
            IcyCanvas canvas = viewer.getCanvas();
            if (canvas == null || !canvas.hasLayer(this)) continue;
            result.add(canvas);
        }
        return result;
    }

    public void beginUpdate() {
        this.updater.beginUpdate();
    }

    public void endUpdate() {
        this.updater.endUpdate();
    }

    public boolean isUpdating() {
        return this.updater.isUpdating();
    }

    @Deprecated
    public void changed() {
        this.painterChanged();
    }

    public void painterChanged() {
        this.updater.changed(new OverlayEvent(this, OverlayEvent.OverlayEventType.PAINTER_CHANGED));
    }

    public void propertyChanged(String propertyName) {
        this.updater.changed(new OverlayEvent(this, OverlayEvent.OverlayEventType.PROPERTY_CHANGED, propertyName));
    }

    @Override
    public void onChanged(CollapsibleEvent object) {
        this.fireOverlayChangedEvent((OverlayEvent)object);
    }

    protected void fireOverlayChangedEvent(OverlayEvent event) {
        for (OverlayListener listener : new ArrayList<OverlayListener>(this.listeners)) {
            listener.overlayChanged(event);
        }
    }

    public void addOverlayListener(OverlayListener listener) {
        this.listeners.add(listener);
    }

    public void removeOverlayListener(OverlayListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
    }

    @Override
    @Deprecated
    public void mousePressed(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    @Override
    @Deprecated
    public void mouseReleased(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    @Override
    @Deprecated
    public void mouseClick(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    @Override
    @Deprecated
    public void mouseMove(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    @Override
    @Deprecated
    public void mouseDrag(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    @Deprecated
    public void mouseEntered(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    @Deprecated
    public void mouseExited(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    @Deprecated
    public void mouseWheelMoved(MouseWheelEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    @Override
    @Deprecated
    public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    @Override
    @Deprecated
    public void keyReleased(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void mousePressed(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (imagePoint != null) {
            this.mousePressed(e, imagePoint.toPoint2D(), canvas);
        } else {
            this.mousePressed(e, (Point2D)null, canvas);
        }
    }

    public void mouseReleased(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (imagePoint != null) {
            this.mouseReleased(e, imagePoint.toPoint2D(), canvas);
        } else {
            this.mouseReleased(e, (Point2D)null, canvas);
        }
    }

    public void mouseClick(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (imagePoint != null) {
            this.mouseClick(e, imagePoint.toPoint2D(), canvas);
        } else {
            this.mouseClick(e, (Point2D)null, canvas);
        }
    }

    public void mouseMove(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (imagePoint != null) {
            this.mouseMove(e, imagePoint.toPoint2D(), canvas);
        } else {
            this.mouseMove(e, (Point2D)null, canvas);
        }
    }

    public void mouseDrag(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (imagePoint != null) {
            this.mouseDrag(e, imagePoint.toPoint2D(), canvas);
        } else {
            this.mouseDrag(e, (Point2D)null, canvas);
        }
    }

    public void mouseEntered(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (imagePoint != null) {
            this.mouseEntered(e, imagePoint.toPoint2D(), canvas);
        } else {
            this.mouseEntered(e, (Point2D)null, canvas);
        }
    }

    public void mouseExited(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (imagePoint != null) {
            this.mouseExited(e, imagePoint.toPoint2D(), canvas);
        } else {
            this.mouseExited(e, (Point2D)null, canvas);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (imagePoint != null) {
            this.mouseWheelMoved(e, imagePoint.toPoint2D(), canvas);
        } else {
            this.mouseWheelMoved(e, (Point2D)null, canvas);
        }
    }

    public void keyPressed(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (imagePoint != null) {
            this.keyPressed(e, imagePoint.toPoint2D(), canvas);
        } else {
            this.keyPressed(e, (Point2D)null, canvas);
        }
    }

    public void keyReleased(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (imagePoint != null) {
            this.keyReleased(e, imagePoint.toPoint2D(), canvas);
        } else {
            this.keyReleased(e, (Point2D)null, canvas);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean loadFromXML(Node node, boolean preserveId) {
        if (node == null) {
            return false;
        }
        this.beginUpdate();
        try {
            if (!preserveId) {
                this.id = XMLUtil.getElementIntValue(node, ID_ID, 0);
                Class<Overlay> clazz = Overlay.class;
                // MONITORENTER : icy.painter.Overlay.class
                if (id_gen <= this.id) {
                    id_gen = this.id + 1;
                }
                // MONITOREXIT : clazz
            }
            this.setName(XMLUtil.getElementValue(node, "name", ""));
            this.setPriority(OverlayPriority.values()[XMLUtil.getElementIntValue(node, "priority", OverlayPriority.SHAPE_NORMAL.ordinal())]);
            this.setReadOnly(XMLUtil.getElementBooleanValue(node, "readOnly", false));
            this.setReceiveKeyEventOnHidden(XMLUtil.getElementBooleanValue(node, "receiveKeyEventOnHidden", false));
            this.setReceiveMouseEventOnHidden(XMLUtil.getElementBooleanValue(node, "receiveMouseEventOnHidden", false));
            return true;
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public boolean loadFromXML(Node node) {
        return this.loadFromXML(node, false);
    }

    @Override
    public boolean saveToXML(Node node) {
        if (node == null) {
            return false;
        }
        XMLUtil.setElementValue(node, ID_CLASSNAME, this.getClass().getName());
        XMLUtil.setElementIntValue(node, ID_ID, this.id);
        XMLUtil.setElementValue(node, "name", this.getName());
        XMLUtil.setElementIntValue(node, "priority", this.getPriority().ordinal());
        XMLUtil.setElementBooleanValue(node, "readOnly", this.isReadOnly());
        XMLUtil.setElementBooleanValue(node, "receiveKeyEventOnHidden", this.getReceiveKeyEventOnHidden());
        XMLUtil.setElementBooleanValue(node, "receiveMouseEventOnHidden", this.getReceiveMouseEventOnHidden());
        return true;
    }

    @Override
    public int compareTo(Overlay o) {
        return o.priority.ordinal() - this.priority.ordinal();
    }

    public static enum OverlayPriority {
        BACKGROUND_LOW,
        BACKGROUND_NORMAL,
        BACKGROUND_HIGH,
        BACKGROUND_TOP,
        IMAGE_LOW,
        IMAGE_NORMAL,
        IMAGE_HIGH,
        IMAGE_TOP,
        SHAPE_LOW,
        SHAPE_NORMAL,
        SHAPE_HIGH,
        SHAPE_TOP,
        TEXT_LOW,
        TEXT_NORMAL,
        TEXT_HIGH,
        TEXT_TOP,
        TOOLTIP_LOW,
        TOOLTIP_NORMAL,
        TOOLTIP_HIGH,
        TOOLTIP_TOP,
        TOPMOST;

    }
}

