/*
 * Decompiled with CFR 0.152.
 */
package icy.preferences;

import icy.preferences.ApplicationPreferences;
import icy.preferences.XMLPreferences;
import plugins.kernel.roi.tool.MagicWand;

public class MagicWandPreferences {
    private static final String PREF_ID = "magicWand";
    private static final String ID_GRADIENT_TOLERANCE_MODE = "gradientToleranceMode";
    private static final String ID_GRADIENT_TOLERANCE_VALUE = "gradientToleranceValue";
    private static final String ID_CONNECTIVITY = "connectivity";
    private static XMLPreferences preferences;

    public static void load() {
        preferences = ApplicationPreferences.getPreferences().node(PREF_ID);
    }

    public static XMLPreferences getPreferences() {
        return preferences;
    }

    public static MagicWand.MagicWandGradientToleranceMode getGradientToleranceMode() {
        return MagicWand.MagicWandGradientToleranceMode.values()[preferences.getInt(ID_GRADIENT_TOLERANCE_MODE, 0)];
    }

    public static double getGradientToleranceValue() {
        return preferences.getDouble(ID_GRADIENT_TOLERANCE_VALUE, 0.0);
    }

    public static MagicWand.MagicWandConnectivity getConnectivity() {
        return MagicWand.MagicWandConnectivity.values()[preferences.getInt(ID_CONNECTIVITY, 0)];
    }

    public static void setGradientToleranceMode(MagicWand.MagicWandGradientToleranceMode value) {
        preferences.putInt(ID_GRADIENT_TOLERANCE_MODE, value.ordinal());
    }

    public static void setGradientToleranceValue(double value) {
        preferences.putDouble(ID_GRADIENT_TOLERANCE_VALUE, value);
    }

    public static void setConnectivity(MagicWand.MagicWandConnectivity value) {
        preferences.putInt(ID_CONNECTIVITY, value.ordinal());
    }
}

