/*
 * Decompiled with CFR 0.152.
 */
package icy.system.thread;

import icy.system.thread.Processor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;

public class SingleProcessor
extends Processor {
    private final boolean queueEnabled;

    public SingleProcessor(boolean enableQueue, String name) {
        super(1, 1);
        this.queueEnabled = enableQueue;
        this.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
        this.setThreadName(name);
    }

    public SingleProcessor(boolean enableQueue) {
        this(enableQueue, "SingleProcessor");
    }

    @Override
    protected synchronized <T> FutureTask<T> submit(Processor.FutureTaskAdapter<T> task) {
        if (this.getActiveCount() == 0) {
            return super.submit(task);
        }
        if (this.queueEnabled) {
            this.removeAllWaitingTasks();
            return super.submit(task);
        }
        return null;
    }

    @Deprecated
    public synchronized boolean requestProcess(Runnable task) {
        return this.submit(task) != null;
    }

    @Deprecated
    public synchronized boolean requestProcess(Runnable task, boolean onAWTEventThread) {
        return this.submit(task, onAWTEventThread) != null;
    }

    public boolean isQueueEnabled() {
        return this.queueEnabled;
    }
}

