/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom.areax;

import icy.type.geom.areax.EdgeX;
import icy.type.geom.areax.RawEdgeArrayList;
import java.util.Comparator;

public class RawSortedEdgeArrayList
extends RawEdgeArrayList {
    Comparator<EdgeX> comparator;

    protected RawSortedEdgeArrayList(int initialCapacity, Comparator<EdgeX> comparator) {
        super(initialCapacity);
        this.comparator = comparator;
    }

    @Override
    protected void add(EdgeX element) {
        int min = 0;
        int max = this.elementCount;
        while (min != max) {
            int middle = (min + max) / 2;
            int k = this.comparator.compare(this.get(middle), element);
            if (k == 0) {
                min = middle + 1;
                max = middle + 1;
                continue;
            }
            if (k < 1) {
                min = middle + 1;
                continue;
            }
            max = middle;
        }
        this.ensureCapacity(this.elementCount + 1);
        if (this.elementCount - min > 0) {
            System.arraycopy(this.elementData, min, this.elementData, min + 1, this.elementCount - min);
        }
        this.elementData[min] = element;
        ++this.elementCount;
    }
}

