/*
 * Decompiled with CFR 0.152.
 */
package icy.util;

import icy.system.SystemUtil;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;

public class EventUtil {
    public static boolean isShiftDown(InputEvent e) {
        return EventUtil.isShiftDown(e, false);
    }

    public static boolean isShiftDown(InputEvent e, boolean exclusive) {
        if (exclusive) {
            return e.getModifiers() == 1;
        }
        return e.isShiftDown();
    }

    public static boolean isAltDown(InputEvent e) {
        return EventUtil.isAltDown(e, false);
    }

    public static boolean isAltDown(InputEvent e, boolean exclusive) {
        if (exclusive) {
            return e.getModifiers() == 8;
        }
        return e.isAltDown();
    }

    public static boolean isControlDown(InputEvent e) {
        return EventUtil.isControlDown(e, false);
    }

    public static boolean isControlDown(InputEvent e, boolean exclusive) {
        if (exclusive) {
            return e.getModifiers() == 2;
        }
        return e.isControlDown();
    }

    public static boolean isMenuControlDown(InputEvent e) {
        return EventUtil.isMenuControlDown(e, false);
    }

    public static boolean isMenuControlDown(InputEvent e, boolean exclusive) {
        if (exclusive) {
            return e.getModifiers() == SystemUtil.getMenuCtrlMask();
        }
        return (e.getModifiers() & SystemUtil.getMenuCtrlMask()) != 0;
    }

    public static boolean isNoModifier(InputEvent e) {
        return e.getModifiers() == 0;
    }

    public static boolean isLeftMouseButton(MouseEvent e) {
        return (e.getModifiers() & 0x10) == 16;
    }

    public static boolean isMiddleMouseButton(MouseEvent e) {
        return (e.getModifiers() & 8) == 8;
    }

    public static boolean isRightMouseButton(MouseEvent e) {
        return (e.getModifiers() & 4) == 4;
    }
}

