/*
 * Decompiled with CFR 0.152.
 */
package icy.workspace;

import icy.network.NetworkUtil;
import icy.network.URLUtil;
import icy.preferences.RepositoryPreferences;
import icy.system.IcyExceptionHandler;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import icy.workspace.Workspace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WorkspaceRepositoryLoader {
    private static final String ID_ROOT = "workspaces";
    private static final String ID_WORKSPACE = "workspace";
    private static final String ID_PATH = "path";
    private static final WorkspaceRepositoryLoader instance = new WorkspaceRepositoryLoader();
    ArrayList<Workspace> workspaces = new ArrayList();
    boolean failed = false;
    private LoadRunner loadRunner;
    private final EventListenerList listeners = new EventListenerList();

    private WorkspaceRepositoryLoader() {
        this.startLoad();
    }

    public static ArrayList<String> getWorkspaceFiles(RepositoryPreferences.RepositoryInfo repos) {
        ArrayList<String> result = new ArrayList<String>();
        Document document = XMLUtil.loadDocument(repos.getLocation(), repos.getAuthenticationInfo(), true);
        if (document != null) {
            Element workspacesNode = XMLUtil.getElement(document.getDocumentElement(), ID_ROOT);
            if (workspacesNode != null) {
                ArrayList<Node> nodes = XMLUtil.getChildren(workspacesNode, ID_WORKSPACE);
                for (Node node : nodes) {
                    String path = XMLUtil.getElementValue(node, ID_PATH, "");
                    if (StringUtil.isEmpty(path)) continue;
                    result.add(path);
                }
            }
        } else if (!NetworkUtil.hasInternetAccess()) {
            System.out.println("You are not connected to internet.");
        } else {
            System.out.println("Can't access repository '" + repos.getName() + "'");
        }
        return result;
    }

    private void startLoad() {
        this.loadRunner = new LoadRunner();
        this.loadRunner.start();
    }

    public static void reload() {
        WorkspaceRepositoryLoader.instance.loadRunner.interrupt();
        instance.startLoad();
    }

    ArrayList<Workspace> loadInternal(RepositoryPreferences.RepositoryInfo repos) {
        ArrayList<String> paths = WorkspaceRepositoryLoader.getWorkspaceFiles(repos);
        if (paths == null) {
            if (!NetworkUtil.hasInternetAccess()) {
                System.out.println("You are not connected to internet.");
            } else {
                System.out.println("Can't access repository '" + repos.getName() + "'");
            }
            return null;
        }
        ArrayList<Workspace> result = new ArrayList<Workspace>();
        for (String path : paths) {
            try {
                Workspace workspace = new Workspace(URLUtil.getURL(path), repos);
                if (workspace.isEmpty()) continue;
                result.add(workspace);
            }
            catch (Exception e) {
                System.err.println("WorkspaceRepositoryLoader.load('" + repos.getLocation() + "') error :");
                IcyExceptionHandler.showErrorMessage(e, false);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Workspace> getWorkspaces() {
        ArrayList<Workspace> arrayList = WorkspaceRepositoryLoader.instance.workspaces;
        synchronized (arrayList) {
            return new ArrayList<Workspace>(WorkspaceRepositoryLoader.instance.workspaces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Workspace getWorkspace(String className) {
        ArrayList<Workspace> arrayList = WorkspaceRepositoryLoader.instance.workspaces;
        synchronized (arrayList) {
            return Workspace.getWorkspace(WorkspaceRepositoryLoader.instance.workspaces, className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Workspace> getWorkspaces(RepositoryPreferences.RepositoryInfo repos) {
        ArrayList<Workspace> result = new ArrayList<Workspace>();
        ArrayList<Workspace> arrayList = WorkspaceRepositoryLoader.instance.workspaces;
        synchronized (arrayList) {
            for (Workspace workspace : WorkspaceRepositoryLoader.instance.workspaces) {
                if (!workspace.getRepository().equals(repos)) continue;
                result.add(workspace);
            }
        }
        return result;
    }

    public static boolean isLoading() {
        return WorkspaceRepositoryLoader.instance.loadRunner.isAlive();
    }

    public static void waitWhileLoading() {
        try {
            WorkspaceRepositoryLoader.instance.loadRunner.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean failed() {
        return WorkspaceRepositoryLoader.instance.failed;
    }

    void changed() {
        this.fireEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(WorkspaceRepositoryLoaderListener listener) {
        EventListenerList eventListenerList = WorkspaceRepositoryLoader.instance.listeners;
        synchronized (eventListenerList) {
            WorkspaceRepositoryLoader.instance.listeners.add(WorkspaceRepositoryLoaderListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(WorkspaceRepositoryLoaderListener listener) {
        EventListenerList eventListenerList = WorkspaceRepositoryLoader.instance.listeners;
        synchronized (eventListenerList) {
            WorkspaceRepositoryLoader.instance.listeners.remove(WorkspaceRepositoryLoaderListener.class, listener);
        }
    }

    private void fireEvent() {
        for (WorkspaceRepositoryLoaderListener listener : (WorkspaceRepositoryLoaderListener[])this.listeners.getListeners(WorkspaceRepositoryLoaderListener.class)) {
            listener.workspaceRepositeryLoaderChanged();
        }
    }

    private class LoadRunner
    extends Thread {
        public LoadRunner() {
            super("Online workspace loader");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!NetworkUtil.hasInternetAccess()) {
                WorkspaceRepositoryLoader.this.failed = true;
                return;
            }
            ArrayList<Workspace> newWorkspaces = new ArrayList<Workspace>();
            WorkspaceRepositoryLoader.this.failed = false;
            try {
                ArrayList<RepositoryPreferences.RepositoryInfo> repositories = RepositoryPreferences.getRepositeries();
                for (RepositoryPreferences.RepositoryInfo repoInfo : repositories) {
                    if (LoadRunner.interrupted()) {
                        return;
                    }
                    if (!repoInfo.isEnabled()) continue;
                    ArrayList<Workspace> workspacesRepos = WorkspaceRepositoryLoader.this.loadInternal(repoInfo);
                    if (workspacesRepos == null) {
                        WorkspaceRepositoryLoader.this.failed = true;
                        return;
                    }
                    newWorkspaces.addAll(workspacesRepos);
                }
                Collections.sort(newWorkspaces);
                ArrayList<Workspace> arrayList = WorkspaceRepositoryLoader.this.workspaces;
                synchronized (arrayList) {
                    WorkspaceRepositoryLoader.this.workspaces = newWorkspaces;
                }
            }
            catch (Exception e) {
                IcyExceptionHandler.showErrorMessage(e, true);
                WorkspaceRepositoryLoader.this.failed = true;
                return;
            }
            WorkspaceRepositoryLoader.this.changed();
        }
    }

    public static interface WorkspaceRepositoryLoaderListener
    extends EventListener {
        public void workspaceRepositeryLoaderChanged();
    }
}

