/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.lang;

import icy.file.xml.XMLPersistent;
import icy.util.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.adufour.blocks.lang.BlockDescriptor;
import plugins.adufour.blocks.lang.WorkFlow;
import plugins.adufour.blocks.util.BlocksException;
import plugins.adufour.blocks.util.BlocksML;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.lang.VarMutableArray;
import plugins.adufour.vars.util.MutableType;

public class Link<T>
implements XMLPersistent {
    private final WorkFlow workFlow;
    public BlockDescriptor srcBlock;
    public Var<T> srcVar;
    public BlockDescriptor dstBlock;
    public Var<T> dstVar;

    public Link(WorkFlow workFlow) {
        this.workFlow = workFlow;
    }

    public Link(WorkFlow workFlow, BlockDescriptor srcBlock, Var<T> output, BlockDescriptor dstBlock, Var<T> input) {
        this(workFlow);
        this.srcBlock = srcBlock;
        this.srcVar = output;
        this.dstBlock = dstBlock;
        this.dstVar = input;
    }

    public Class<?> getType() {
        return this.srcVar.getType();
    }

    @Override
    public boolean loadFromXML(Node node) {
        String type;
        Element linkNode = (Element)node;
        int srcBlockID = XMLUtil.getAttributeIntValue(linkNode, "srcBlockID", -1);
        String srcVarID = XMLUtil.getAttributeValue(linkNode, "srcVarID", null);
        int dstBlockID = XMLUtil.getAttributeIntValue(linkNode, "dstBlockID", -1);
        String dstVarID = XMLUtil.getAttributeValue(linkNode, "dstVarID", null);
        BlockDescriptor theSrcBlock = this.workFlow.getBlockByID(srcBlockID);
        Var theSrcVar = theSrcBlock.outputVars.get(srcVarID);
        if (theSrcVar == null) {
            theSrcVar = theSrcBlock.inputVars.get(srcVarID);
        }
        if (theSrcVar == null) {
            System.err.println("Cannot create a link from variable " + srcVarID + " (from block " + theSrcBlock + ")");
            return false;
        }
        if (theSrcVar instanceof MutableType && (type = XMLUtil.getAttributeValue(linkNode, "srcVarType", null)) != null) {
            try {
                if (theSrcVar instanceof VarMutable) {
                    Class<?> mutableType = BlocksML.getPrimitiveType(type);
                    ((MutableType)((Object)theSrcVar)).setType(mutableType != null ? mutableType : Class.forName(type));
                } else if (theSrcVar instanceof VarMutableArray) {
                    type = "[L" + type + ";";
                    ((MutableType)((Object)theSrcVar)).setType(Class.forName(type));
                }
            }
            catch (ClassNotFoundException e1) {
                throw new BlocksException("Cannot create link: unknown type " + type, true);
            }
        }
        BlockDescriptor theDstBlock = this.workFlow.getBlockByID(dstBlockID);
        Var theDstVar = theDstBlock.inputVars.get(dstVarID);
        this.workFlow.addLink(theSrcBlock, theSrcVar, theDstBlock, theDstVar);
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        return false;
    }
}

