/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.tools.roi;

import icy.plugin.abstract_.Plugin;
import icy.roi.ROI;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.gui.model.IntegerRangeModel;
import plugins.adufour.vars.lang.VarEnum;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarROIArray;

abstract class MorphROI
extends Plugin
implements ROIBlock {
    VarROIArray roiIN = new VarROIArray("List of ROI");
    VarInteger x = new VarInteger("Along X", 1);
    VarInteger y = new VarInteger("Along Y", 1);
    VarInteger z = new VarInteger("Along Z", 1);
    VarEnum<MorphUnit> unit = new VarEnum<MorphUnit>("Unit", MorphUnit.PIXELS);
    VarROIArray roiOUT;

    MorphROI() {
    }

    @Override
    public void declareInput(VarList inputMap) {
        this.x.setDefaultEditorModel(new IntegerRangeModel(1, 0, 100, 1));
        this.y.setDefaultEditorModel(new IntegerRangeModel(1, 0, 100, 1));
        this.z.setDefaultEditorModel(new IntegerRangeModel(1, 0, 100, 1));
        inputMap.add("input ROI", this.roiIN);
        inputMap.add("X radius", this.x);
        inputMap.add("Y radius", this.y);
        inputMap.add("Z radius", this.z);
        inputMap.add("unit", this.unit);
    }

    @Override
    public void declareOutput(VarList outputMap) {
        outputMap.add("output ROI", this.roiOUT);
    }

    static int percentageToRadiusX(ROI roi, int pct) {
        double size = roi.getBounds5D().getSizeX();
        double diff = size * (double)pct / 100.0;
        return (int)Math.round(diff * 0.5);
    }

    static int percentageToRadiusY(ROI roi, int pct) {
        double size = roi.getBounds5D().getSizeY();
        double diff = size * (double)pct / 100.0;
        return (int)Math.round(diff * 0.5);
    }

    static int percentageToRadiusZ(ROI roi, int pct) {
        double size = roi.getBounds5D().getSizeZ();
        double diff = size * (double)pct / 100.0;
        return (int)Math.round(diff * 0.5);
    }

    protected static enum MorphUnit {
        PIXELS("Radius (px)"),
        PERCENTAGE("Scale (%)");

        private final String displayText;

        private MorphUnit(String displayText) {
            this.displayText = displayText;
        }

        public String toString() {
            return this.displayText;
        }
    }
}

