/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.util;

import icy.gui.frame.progress.AnnounceFrame;
import icy.main.Icy;
import icy.network.NetworkUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginInstaller;
import icy.plugin.PluginLoader;
import icy.plugin.PluginRepositoryLoader;
import icy.plugin.PluginUpdater;
import icy.plugin.interface_.PluginBundled;
import icy.system.IcyExceptionHandler;
import icy.system.IcyHandledException;
import icy.system.thread.ThreadUtil;
import icy.util.ClassUtil;
import icy.util.XMLUtil;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.lang.BlockDescriptor;
import plugins.adufour.blocks.lang.Link;
import plugins.adufour.blocks.lang.WorkFlow;
import plugins.adufour.blocks.tools.input.InputBlock;
import plugins.adufour.blocks.tools.output.OutputBlock;
import plugins.adufour.blocks.util.BlocksException;
import plugins.adufour.blocks.util.BlocksReloadedException;
import plugins.adufour.blocks.util.NoSuchVariableException;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.protocols.Protocols;
import plugins.adufour.vars.gui.model.TypeSelectionModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.lang.VarMutableArray;
import plugins.adufour.vars.lang.VarString;
import plugins.adufour.vars.util.MutableType;
import plugins.adufour.vars.util.VarListener;

public class BlocksML {
    private static final String RUNTIME = "runtime";
    private static BlocksML instance = new BlocksML();
    public static final int CURRENT_VERSION = 4;
    public static final FileFilter XML_FILE_FILTER = new FileFilter(){

        @Override
        public String getDescription() {
            return "Icy protocols (.xml | .protocol)";
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getPath().toLowerCase().endsWith(".xml") || f.getPath().toLowerCase().endsWith(".protocol");
        }
    };
    private Transformer transformer;
    private VarString status = new VarString("status", "");

    public static BlocksML getInstance() {
        return instance;
    }

    private BlocksML() {
        try {
            this.transformer = TransformerFactory.newInstance().newTransformer();
            this.transformer.setOutputProperty("method", "xml");
            this.transformer.setOutputProperty("encoding", "ISO-8859-1");
            this.transformer.setOutputProperty("encoding", "UTF-8");
            this.transformer.setOutputProperty("omit-xml-declaration", "no");
            this.transformer.setOutputProperty("indent", "yes");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addStatusListener(VarListener<String> listener) {
        this.status.addListener(listener);
    }

    public void removeStatusListener(VarListener<String> listener) {
        this.status.removeListener(listener);
    }

    public synchronized String toString(WorkFlow workFlow) throws TransformerException {
        return this.toString(this.toXML(workFlow));
    }

    public synchronized String toString(Document xml) throws TransformerException {
        xml.normalizeDocument();
        DocumentType doctype = xml.getDoctype();
        DOMSource domSource = new DOMSource(xml);
        StringWriter string = new StringWriter();
        StreamResult streamResult = new StreamResult(string);
        if (doctype != null) {
            this.transformer.setOutputProperty("doctype-public", doctype.getPublicId());
            this.transformer.setOutputProperty("doctype-system", doctype.getSystemId());
        }
        this.transformer.transform(domSource, streamResult);
        return string.toString();
    }

    public synchronized Document toXML(WorkFlow workFlow) {
        Document xml = XMLUtil.createDocument(false);
        Element workSpaceRoot = XMLUtil.createRootElement(xml, "protocol");
        XMLUtil.setAttributeIntValue(workSpaceRoot, "VERSION", 4);
        switch (4) {
            case 1: {
                this.saveWorkFlow_V1(workFlow, workSpaceRoot);
                break;
            }
            case 2: {
                this.saveWorkFlow_V2(workFlow, workSpaceRoot);
                break;
            }
            case 3: {
                this.saveWorkFlow_V3(workFlow, workSpaceRoot);
                break;
            }
            case 4: {
                this.saveWorkFlow_V4(workFlow, workSpaceRoot);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot save Blocks ML version 4");
            }
        }
        return xml;
    }

    public synchronized void saveWorkFlow(WorkFlow workFlow, File f) throws BlocksException, IOException {
        Document xml = this.toXML(workFlow);
        if (!XMLUtil.saveDocument(xml, f)) {
            throw new IOException("Unable to save the protocol.\nDo you have write permissions to the destination folder.");
        }
    }

    @Deprecated
    public synchronized void saveWorkFlow_V1(WorkFlow workFlow, Element workFlowRoot) {
        Element blocksNode = XMLUtil.addElement(workFlowRoot, "blocks");
        for (BlockDescriptor blockData : workFlow) {
            Block block = blockData.getBlock();
            Element blockNode = block instanceof WorkFlow ? XMLUtil.addElement(blocksNode, "workflow") : XMLUtil.addElement(blocksNode, "block");
            XMLUtil.setAttributeValue(blockNode, "type", block.getClass().getCanonicalName());
            XMLUtil.setAttributeIntValue(blockNode, "ID", workFlow.indexOf(blockData));
            XMLUtil.setAttributeIntValue(blockNode, "xLocation", blockData.getLocation().x);
            XMLUtil.setAttributeIntValue(blockNode, "yLocation", blockData.getLocation().y);
            if (block instanceof WorkFlow) {
                Var<?> var2;
                WorkFlow innerWorkFlow = (WorkFlow)block;
                this.saveWorkFlow_V1(innerWorkFlow, blockNode);
                Element varRoot = XMLUtil.addElement(blockNode, "variables");
                Element inputVarRoot = XMLUtil.addElement(varRoot, "input");
                for (Var<?> var2 : blockData.inputVars) {
                    BlockDescriptor owner = innerWorkFlow.getInputOwner(var2);
                    Element varNode = XMLUtil.addElement(inputVarRoot, "variable");
                    XMLUtil.setAttributeIntValue(varNode, "ID", blockData.inputVars.indexOf(var2));
                    XMLUtil.setAttributeIntValue(varNode, "blockID", innerWorkFlow.indexOf(owner));
                    XMLUtil.setAttributeIntValue(varNode, "varID", owner.inputVars.indexOf(var2));
                    XMLUtil.setAttributeBooleanValue(varNode, "visible", blockData.inputVars.isVisible(var2));
                }
                Element outputVarRoot = XMLUtil.addElement(varRoot, "output");
                var2 = blockData.outputVars.iterator();
                while (var2.hasNext()) {
                    Var var3 = (Var)var2.next();
                    BlockDescriptor owner = innerWorkFlow.getOutputOwner(var3);
                    Element varNode = XMLUtil.addElement(outputVarRoot, "variable");
                    XMLUtil.setAttributeIntValue(varNode, "ID", blockData.outputVars.indexOf(var3));
                    XMLUtil.setAttributeIntValue(varNode, "blockID", innerWorkFlow.indexOf(owner));
                    XMLUtil.setAttributeIntValue(varNode, "varID", owner.outputVars.indexOf(var3));
                    XMLUtil.setAttributeBooleanValue(varNode, "visible", blockData.outputVars.isVisible(var3));
                }
                continue;
            }
            Element varRoot = XMLUtil.addElement(blockNode, "variables");
            Element inputVarRoot = XMLUtil.addElement(varRoot, "input");
            for (Var var : blockData.inputVars) {
                Element varNode = XMLUtil.addElement(inputVarRoot, "variable");
                XMLUtil.setAttributeIntValue(varNode, "ID", blockData.inputVars.indexOf(var));
                XMLUtil.setAttributeValue(varNode, "name", var.getName());
                var.saveToXML(varNode);
                XMLUtil.setAttributeBooleanValue(varNode, "visible", blockData.inputVars.isVisible(var));
            }
            Element outputVarRoot = XMLUtil.addElement(varRoot, "output");
            for (Var<?> var2 : blockData.outputVars) {
                Element varNode = XMLUtil.addElement(outputVarRoot, "variable");
                XMLUtil.setAttributeIntValue(varNode, "ID", blockData.outputVars.indexOf(var2));
                XMLUtil.setAttributeValue(varNode, "name", var2.getName());
                var2.saveToXML(varNode);
                XMLUtil.setAttributeBooleanValue(varNode, "visible", blockData.outputVars.isVisible(var2));
            }
        }
        Element linkRoot = XMLUtil.addElement(workFlowRoot, "links");
        for (Link<?> link : workFlow.getLinksIterator()) {
            Element linkNode = XMLUtil.addElement(linkRoot, "link");
            XMLUtil.setAttributeIntValue(linkNode, "srcBlockID", workFlow.indexOf(link.srcBlock));
            XMLUtil.setAttributeIntValue(linkNode, "srcVarID", link.srcBlock.outputVars.indexOf(link.srcVar));
            XMLUtil.setAttributeIntValue(linkNode, "dstBlockID", workFlow.indexOf(link.dstBlock));
            XMLUtil.setAttributeIntValue(linkNode, "dstVarID", link.dstBlock.inputVars.indexOf(link.dstVar));
        }
    }

    @Deprecated
    public synchronized void saveWorkFlow_V2(WorkFlow workFlow, Element workFlowRoot) {
        Element blocksNode = XMLUtil.addElement(workFlowRoot, "blocks");
        for (BlockDescriptor blockData : workFlow) {
            Element blockNode;
            Block block = blockData.getBlock();
            if (block instanceof WorkFlow) {
                blockNode = XMLUtil.addElement(blocksNode, "workflow");
                XMLUtil.setAttributeBooleanValue(blockNode, "collapsed", blockData.isCollapsed());
            } else {
                blockNode = XMLUtil.addElement(blocksNode, "block");
            }
            XMLUtil.setAttributeValue(blockNode, "type", block.getClass().getCanonicalName());
            XMLUtil.setAttributeIntValue(blockNode, "ID", workFlow.indexOf(blockData));
            XMLUtil.setAttributeIntValue(blockNode, "xLocation", blockData.getLocation().x);
            XMLUtil.setAttributeIntValue(blockNode, "yLocation", blockData.getLocation().y);
            if (blockData.isWorkFlow()) {
                Var<?> var2;
                WorkFlow innerWorkFlow = (WorkFlow)block;
                this.saveWorkFlow_V2(innerWorkFlow, blockNode);
                Element varRoot = XMLUtil.addElement(blockNode, "variables");
                Element inputVarRoot = XMLUtil.addElement(varRoot, "input");
                for (Var<?> var2 : blockData.inputVars) {
                    BlockDescriptor owner = innerWorkFlow.getInputOwner(var2);
                    Element varNode = XMLUtil.addElement(inputVarRoot, "variable");
                    XMLUtil.setAttributeValue(varNode, "ID", blockData.inputVars.getID(var2));
                    XMLUtil.setAttributeIntValue(varNode, "blockID", innerWorkFlow.indexOf(owner));
                    XMLUtil.setAttributeValue(varNode, "varID", owner.inputVars.getID(var2));
                    XMLUtil.setAttributeBooleanValue(varNode, "visible", blockData.inputVars.isVisible(var2));
                }
                Element outputVarRoot = XMLUtil.addElement(varRoot, "output");
                var2 = blockData.outputVars.iterator();
                while (var2.hasNext()) {
                    Var var3 = (Var)var2.next();
                    BlockDescriptor owner = innerWorkFlow.getOutputOwner(var3);
                    Element varNode = XMLUtil.addElement(outputVarRoot, "variable");
                    XMLUtil.setAttributeValue(varNode, "ID", blockData.outputVars.getID(var3));
                    XMLUtil.setAttributeIntValue(varNode, "blockID", innerWorkFlow.indexOf(owner));
                    XMLUtil.setAttributeValue(varNode, "varID", owner.outputVars.getID(var3));
                    XMLUtil.setAttributeBooleanValue(varNode, "visible", blockData.outputVars.isVisible(var3));
                }
                continue;
            }
            Element varRoot = XMLUtil.addElement(blockNode, "variables");
            Element inputVarRoot = XMLUtil.addElement(varRoot, "input");
            for (Var var : blockData.inputVars) {
                Element varNode = XMLUtil.addElement(inputVarRoot, "variable");
                XMLUtil.setAttributeValue(varNode, "ID", blockData.inputVars.getID(var));
                XMLUtil.setAttributeValue(varNode, "name", var.getName());
                var.saveToXML(varNode);
                XMLUtil.setAttributeBooleanValue(varNode, "visible", blockData.inputVars.isVisible(var));
                if (var instanceof VarMutable && var.getType() != null) {
                    XMLUtil.setAttributeValue(varNode, "type", var.getType().getCanonicalName());
                    continue;
                }
                if (!(var instanceof VarMutableArray) || var.getType() == null) continue;
                XMLUtil.setAttributeValue(varNode, "type", var.getType().getComponentType().getCanonicalName());
            }
            Element outputVarRoot = XMLUtil.addElement(varRoot, "output");
            for (Var<?> var2 : blockData.outputVars) {
                Element varNode = XMLUtil.addElement(outputVarRoot, "variable");
                XMLUtil.setAttributeValue(varNode, "ID", blockData.outputVars.getID(var2));
                XMLUtil.setAttributeValue(varNode, "name", var2.getName());
                var2.saveToXML(varNode);
                XMLUtil.setAttributeBooleanValue(varNode, "visible", blockData.outputVars.isVisible(var2));
                if (var2 instanceof VarMutable && var2.getType() != null) {
                    XMLUtil.setAttributeValue(varNode, "type", var2.getType().getCanonicalName());
                    continue;
                }
                if (!(var2 instanceof VarMutableArray) || var2.getType() == null) continue;
                XMLUtil.setAttributeValue(varNode, "type", var2.getType().getComponentType().getCanonicalName());
            }
        }
        Element linkRoot = XMLUtil.addElement(workFlowRoot, "links");
        for (Link<?> link : workFlow.getLinksIterator()) {
            Element linkNode = XMLUtil.addElement(linkRoot, "link");
            XMLUtil.setAttributeIntValue(linkNode, "srcBlockID", workFlow.indexOf(link.srcBlock));
            XMLUtil.setAttributeValue(linkNode, "srcVarID", link.srcBlock.getVarID(link.srcVar));
            XMLUtil.setAttributeIntValue(linkNode, "dstBlockID", workFlow.indexOf(link.dstBlock));
            XMLUtil.setAttributeValue(linkNode, "dstVarID", link.dstBlock.getVarID(link.dstVar));
        }
    }

    @Deprecated
    public synchronized void saveWorkFlow_V3(WorkFlow workFlow, Element workFlowRoot) {
        Element blocksNode = XMLUtil.addElement(workFlowRoot, "blocks");
        for (BlockDescriptor blockData : workFlow) {
            Element varNode;
            Element blockNode;
            Block block = blockData.getBlock();
            if (block instanceof WorkFlow) {
                blockNode = XMLUtil.addElement(blocksNode, "workflow");
                XMLUtil.setAttributeBooleanValue(blockNode, "collapsed", blockData.isCollapsed());
                XMLUtil.setAttributeIntValue(blockNode, "width", blockData.getDimension().width);
                XMLUtil.setAttributeIntValue(blockNode, "height", blockData.getDimension().height);
            } else {
                blockNode = XMLUtil.addElement(blocksNode, "block");
            }
            String blockClass = block.getClass().getCanonicalName();
            String mainClass = block instanceof PluginBundled ? ((PluginBundled)((Object)block)).getMainPluginClassName() : blockClass;
            XMLUtil.setAttributeValue(blockNode, "className", mainClass);
            XMLUtil.setAttributeValue(blockNode, "blockType", blockClass);
            XMLUtil.setAttributeIntValue(blockNode, "ID", workFlow.indexOf(blockData));
            XMLUtil.setAttributeIntValue(blockNode, "xLocation", blockData.getLocation().x);
            XMLUtil.setAttributeIntValue(blockNode, "yLocation", blockData.getLocation().y);
            if (blockData.isWorkFlow()) {
                Var<?> var2;
                WorkFlow innerWorkFlow = (WorkFlow)block;
                this.saveWorkFlow_V3(innerWorkFlow, blockNode);
                Element varRoot = XMLUtil.addElement(blockNode, "variables");
                Element inputVarRoot = XMLUtil.addElement(varRoot, "input");
                for (Var<?> var2 : blockData.inputVars) {
                    varNode = XMLUtil.addElement(inputVarRoot, "variable");
                    XMLUtil.setAttributeValue(varNode, "ID", innerWorkFlow.getInputVarID(var2));
                    XMLUtil.setAttributeBooleanValue(varNode, "visible", blockData.inputVars.isVisible(var2));
                }
                Element outputVarRoot = XMLUtil.addElement(varRoot, "output");
                var2 = blockData.outputVars.iterator();
                while (var2.hasNext()) {
                    Var var3 = (Var)var2.next();
                    Element varNode2 = XMLUtil.addElement(outputVarRoot, "variable");
                    XMLUtil.setAttributeValue(varNode2, "ID", innerWorkFlow.getOutputVarID(var3));
                    XMLUtil.setAttributeBooleanValue(varNode2, "visible", blockData.outputVars.isVisible(var3));
                }
                continue;
            }
            Element varRoot = XMLUtil.addElement(blockNode, "variables");
            Element inputVarRoot = XMLUtil.addElement(varRoot, "input");
            for (Var var : blockData.inputVars) {
                Element varNode3 = XMLUtil.addElement(inputVarRoot, "variable");
                XMLUtil.setAttributeValue(varNode3, "ID", blockData.inputVars.getID(var));
                XMLUtil.setAttributeValue(varNode3, "name", var.getName());
                var.saveToXML(varNode3);
                XMLUtil.setAttributeBooleanValue(varNode3, "visible", blockData.inputVars.isVisible(var));
                if (var instanceof VarMutable && var.getType() != null) {
                    XMLUtil.setAttributeValue(varNode3, "type", var.getType().getCanonicalName());
                    continue;
                }
                if (!(var instanceof VarMutableArray) || var.getType() == null) continue;
                XMLUtil.setAttributeValue(varNode3, "type", var.getType().getComponentType().getCanonicalName());
            }
            Element outputVarRoot = XMLUtil.addElement(varRoot, "output");
            for (Var<?> var2 : blockData.outputVars) {
                varNode = XMLUtil.addElement(outputVarRoot, "variable");
                XMLUtil.setAttributeValue(varNode, "ID", blockData.outputVars.getID(var2));
                XMLUtil.setAttributeValue(varNode, "name", var2.getName());
                var2.saveToXML(varNode);
                XMLUtil.setAttributeBooleanValue(varNode, "visible", blockData.outputVars.isVisible(var2));
                if (var2 instanceof VarMutable && var2.getType() != null) {
                    XMLUtil.setAttributeValue(varNode, "type", var2.getType().getCanonicalName());
                    continue;
                }
                if (!(var2 instanceof VarMutableArray) || var2.getType() == null) continue;
                XMLUtil.setAttributeValue(varNode, "type", var2.getType().getComponentType().getCanonicalName());
            }
        }
        Element linkRoot = XMLUtil.addElement(workFlowRoot, "links");
        for (Link<?> link : workFlow.getLinksIterator()) {
            Element linkNode = XMLUtil.addElement(linkRoot, "link");
            XMLUtil.setAttributeIntValue(linkNode, "srcBlockID", workFlow.indexOf(link.srcBlock));
            XMLUtil.setAttributeValue(linkNode, "srcVarID", link.srcBlock.getVarID(link.srcVar));
            XMLUtil.setAttributeIntValue(linkNode, "dstBlockID", workFlow.indexOf(link.dstBlock));
            XMLUtil.setAttributeValue(linkNode, "dstVarID", link.dstBlock.getVarID(link.dstVar));
        }
    }

    public synchronized void saveWorkFlow_V4(WorkFlow workFlow, Element workFlowRoot) {
        Element blocksNode = XMLUtil.addElement(workFlowRoot, "blocks");
        for (BlockDescriptor blockData : workFlow) {
            Element blockNode;
            Block block = blockData.getBlock();
            if (block instanceof WorkFlow) {
                blockNode = XMLUtil.addElement(blocksNode, "workflow");
                XMLUtil.setAttributeBooleanValue(blockNode, "collapsed", blockData.isCollapsed());
            } else {
                blockNode = XMLUtil.addElement(blocksNode, "block");
            }
            String blockClass = block.getClass().getName();
            String mainClass = block instanceof PluginBundled ? ((PluginBundled)((Object)block)).getMainPluginClassName() : blockClass;
            XMLUtil.setAttributeValue(blockNode, "className", mainClass);
            XMLUtil.setAttributeValue(blockNode, "blockType", blockClass);
            XMLUtil.setAttributeIntValue(blockNode, "ID", blockData.getID());
            XMLUtil.setAttributeIntValue(blockNode, "xLocation", blockData.getLocation().x);
            XMLUtil.setAttributeIntValue(blockNode, "yLocation", blockData.getLocation().y);
            XMLUtil.setAttributeIntValue(blockNode, "width", blockData.getDimension().width);
            XMLUtil.setAttributeIntValue(blockNode, "height", blockData.getDimension().height);
            XMLUtil.setAttributeBooleanValue(blockNode, "collapsed", blockData.isCollapsed());
            XMLUtil.setAttributeValue(blockNode, "definedName", blockData.getDefinedName());
            XMLUtil.setAttributeBooleanValue(blockNode, "keepsResults", blockData.keepsResults());
            if (block instanceof InputBlock || block instanceof OutputBlock) {
                XMLUtil.setAttributeValue(blockNode, "CommandLineID", blockData.getCommandLineID());
            }
            if (blockData.isWorkFlow()) {
                Var<?> var2;
                WorkFlow innerWorkFlow = (WorkFlow)block;
                this.saveWorkFlow_V4(innerWorkFlow, blockNode);
                Element varRoot = XMLUtil.addElement(blockNode, "variables");
                Element inputVarRoot = XMLUtil.addElement(varRoot, "input");
                for (Var<?> var2 : blockData.inputVars) {
                    BlockDescriptor owner = innerWorkFlow.getInputOwner(var2);
                    if (owner == null) {
                        System.err.println("Warning: could not find owner for input variable: \"" + var2 + "\", skipping");
                        continue;
                    }
                    Element varNode = XMLUtil.addElement(inputVarRoot, "variable");
                    XMLUtil.setAttributeValue(varNode, "ID", blockData.getVarID(var2));
                    XMLUtil.setAttributeIntValue(varNode, "blockID", owner.getID());
                    var2.saveToXML(varNode);
                    XMLUtil.setAttributeBooleanValue(varNode, "visible", blockData.inputVars.isVisible(var2));
                }
                Element outputVarRoot = XMLUtil.addElement(varRoot, "output");
                var2 = blockData.outputVars.iterator();
                while (var2.hasNext()) {
                    Var var3 = (Var)var2.next();
                    BlockDescriptor owner = innerWorkFlow.getOutputOwner(var3);
                    if (owner == null) {
                        System.err.println("Warning: could not find owner for output variable: \"" + var3 + "\", skipping");
                        continue;
                    }
                    Element varNode = XMLUtil.addElement(outputVarRoot, "variable");
                    XMLUtil.setAttributeValue(varNode, "ID", blockData.getVarID(var3));
                    XMLUtil.setAttributeIntValue(varNode, "blockID", owner.getID());
                    XMLUtil.setAttributeBooleanValue(varNode, "visible", blockData.outputVars.isVisible(var3));
                }
                continue;
            }
            Element varRoot = XMLUtil.addElement(blockNode, "variables");
            Element inputVarRoot = XMLUtil.addElement(varRoot, "input");
            for (Var var : blockData.inputVars) {
                Element varNode = XMLUtil.addElement(inputVarRoot, "variable");
                XMLUtil.setAttributeValue(varNode, "ID", blockData.getVarID(var));
                XMLUtil.setAttributeValue(varNode, "name", var.getName());
                if (var.getReference() == null) {
                    var.saveToXML(varNode);
                }
                XMLUtil.setAttributeBooleanValue(varNode, "visible", blockData.inputVars.isVisible(var));
                if (var instanceof MutableType) {
                    if (var instanceof VarMutable && var.getType() != null) {
                        XMLUtil.setAttributeValue(varNode, "type", var.getType().getName());
                    } else if (var instanceof VarMutableArray && var.getType() != null) {
                        XMLUtil.setAttributeValue(varNode, "type", var.getType().getComponentType().getName());
                    }
                }
                XMLUtil.setAttributeBooleanValue(varNode, RUNTIME, blockData.inputVars.isRuntimeVariable(var));
            }
            Element outputVarRoot = XMLUtil.addElement(varRoot, "output");
            for (Var<?> var2 : blockData.outputVars) {
                Element varNode = XMLUtil.addElement(outputVarRoot, "variable");
                XMLUtil.setAttributeValue(varNode, "ID", blockData.getVarID(var2));
                XMLUtil.setAttributeValue(varNode, "name", var2.getName());
                XMLUtil.setAttributeBooleanValue(varNode, "visible", blockData.outputVars.isVisible(var2));
                if (var2 instanceof MutableType) {
                    if (var2 instanceof VarMutable && var2.getType() != null) {
                        XMLUtil.setAttributeValue(varNode, "type", var2.getType().getName());
                    } else if (var2 instanceof VarMutableArray && var2.getType() != null) {
                        XMLUtil.setAttributeValue(varNode, "type", var2.getType().getComponentType().getName());
                    }
                }
                XMLUtil.setAttributeBooleanValue(varNode, RUNTIME, blockData.outputVars.isRuntimeVariable(var2));
            }
        }
        Element linkRoot = XMLUtil.addElement(workFlowRoot, "links");
        for (Link<?> link : workFlow.getLinksIterator()) {
            Element linkNode = XMLUtil.addElement(linkRoot, "link");
            XMLUtil.setAttributeIntValue(linkNode, "srcBlockID", link.srcBlock.getID());
            XMLUtil.setAttributeValue(linkNode, "srcVarID", link.srcBlock.getVarID(link.srcVar));
            if (link.srcVar instanceof MutableType) {
                if (link.srcVar instanceof VarMutable && link.srcVar.getType() != null) {
                    XMLUtil.setAttributeValue(linkNode, "srcVarType", link.srcVar.getType().getName());
                } else if (link.srcVar instanceof VarMutableArray && link.srcVar.getType() != null) {
                    XMLUtil.setAttributeValue(linkNode, "srcVarType", link.srcVar.getType().getComponentType().getName());
                }
            }
            XMLUtil.setAttributeIntValue(linkNode, "dstBlockID", link.dstBlock.getID());
            XMLUtil.setAttributeValue(linkNode, "dstVarID", link.dstBlock.getVarID(link.dstVar));
        }
    }

    public synchronized boolean loadWorkFlow(Document xml, WorkFlow targetWorkFlow) {
        Element xmlRoot = XMLUtil.getRootElement(xml);
        String rootName = xmlRoot.getNodeName();
        if (!rootName.equalsIgnoreCase("protocol") && !rootName.equalsIgnoreCase("workspace")) {
            throw new IcyHandledException("The selected file is not an Icy protocol");
        }
        int fileVersion = XMLUtil.getAttributeIntValue(xmlRoot, "VERSION", -1);
        Set<String> missingPlugins = this.getMissingPlugins(xmlRoot, fileVersion);
        if (missingPlugins.size() > 0) {
            if (!NetworkUtil.hasInternetAccess()) {
                throw new IcyHandledException("Some plugins required by this protocol are missing,  but no internet connection is available");
            }
            String message = "[Protocols] Installing required plugins...";
            System.out.println(message);
            AnnounceFrame announcement = null;
            if (!Icy.getMainInterface().isHeadLess()) {
                announcement = new AnnounceFrame(message);
            }
            HashSet<PluginDescriptor> descriptors = new HashSet<PluginDescriptor>(missingPlugins.size());
            for (String className : missingPlugins) {
                PluginDescriptor pDesc = PluginRepositoryLoader.getPlugin(className);
                if (pDesc == null) {
                    if (PluginLoader.getPlugins(Block.class, true, false, false).size() == 0) {
                        throw new BlocksReloadedException();
                    }
                    throw new BlocksException("Couldn't find plugin " + ClassUtil.getSimpleClassName(className) + " online", true);
                }
                descriptors.add(pDesc);
            }
            for (PluginDescriptor pDesc : descriptors) {
                PluginInstaller.install(pDesc, false);
            }
            PluginInstaller.waitInstall();
            PluginLoader.waitWhileLoading();
            System.out.println("[Protocols] Plugins installed successfully.");
            if (announcement != null) {
                announcement.close();
            }
            throw new BlocksReloadedException();
        }
        switch (fileVersion) {
            case 1: {
                this.loadWorkFlow_V1(xmlRoot, targetWorkFlow);
                break;
            }
            case 2: {
                this.loadWorkFlow_V2(xmlRoot, targetWorkFlow);
                break;
            }
            case 3: {
                this.loadWorkFlow_V3(xmlRoot, targetWorkFlow);
                break;
            }
            case 4: {
                this.loadWorkFlow_V4(xmlRoot, targetWorkFlow);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown Protocol version: " + fileVersion);
            }
        }
        return fileVersion == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getMissingPlugins(Element workFlowRoot, int fileVersion) {
        HashSet<String> missingPlugins = new HashSet<String>();
        Element blocksRoot = XMLUtil.getElement(workFlowRoot, "blocks");
        if (blocksRoot == null) {
            return missingPlugins;
        }
        ArrayList<Element> blocksNode = XMLUtil.getElements(blocksRoot);
        for (Element blockNode : blocksNode) {
            String blockTag = fileVersion <= 2 ? "type" : "blockType";
            String blockType = XMLUtil.getAttributeValue(blockNode, blockTag, null);
            String pluginClassName = XMLUtil.getAttributeValue(blockNode, "className", blockType);
            try {
                ClassUtil.findClass(blockType);
            }
            catch (ClassNotFoundException e) {
                PluginDescriptor mainPlugin = PluginLoader.getPlugin(pluginClassName);
                if (mainPlugin == null || PluginUpdater.getUpdate(mainPlugin) != null) {
                    missingPlugins.add(pluginClassName);
                    continue;
                }
                IcyExceptionHandler.handleException(mainPlugin, (Throwable)e, false);
            }
            finally {
                missingPlugins.addAll(this.getMissingPlugins(blockNode, fileVersion));
            }
        }
        return missingPlugins;
    }

    @Deprecated
    public synchronized void loadWorkFlow_V1(Element workFlowRoot, WorkFlow workFlow) {
        Element blocksRoot = XMLUtil.getElement(workFlowRoot, "blocks");
        ArrayList<Element> blocksNode = XMLUtil.getElements(blocksRoot);
        for (Element blockNode : blocksNode) {
            String className = XMLUtil.getAttributeValue(blockNode, "type", null);
            int xPos = XMLUtil.getAttributeIntValue(blockNode, "xLocation", 0);
            int yPos = XMLUtil.getAttributeIntValue(blockNode, "yLocation", 0);
            try {
                Object outVarRoot;
                Element inVarRoot;
                Element varRoot;
                BlockDescriptor blockInfo;
                Class<?> blockClass = ClassUtil.findClass(className);
                Block block = (Block)blockClass.newInstance();
                if (block == null) {
                    throw new BlocksException("Couldn't create block from class " + blockClass.getName(), true);
                }
                if (block instanceof WorkFlow) {
                    this.loadWorkFlow_V1(blockNode, (WorkFlow)block);
                    blockInfo = workFlow.addBlock(-1, block, new Point(xPos, yPos));
                    varRoot = XMLUtil.getElement(blockNode, "variables");
                    inVarRoot = XMLUtil.getElement(varRoot, "input");
                    for (Element element : XMLUtil.getElements(inVarRoot)) {
                        int id = XMLUtil.getAttributeIntValue(element, "ID", -1);
                        Var var = blockInfo.inputVars.get(id);
                        boolean visible = XMLUtil.getAttributeBooleanValue(element, "visible", false);
                        blockInfo.inputVars.setVisible(var, visible);
                    }
                    outVarRoot = XMLUtil.getElement(varRoot, "output");
                    for (Element varNode3 : XMLUtil.getElements((Node)outVarRoot)) {
                        int id = XMLUtil.getAttributeIntValue(varNode3, "ID", -1);
                        Var var = blockInfo.outputVars.get(id);
                        boolean visible = XMLUtil.getAttributeBooleanValue(varNode3, "visible", false);
                        blockInfo.outputVars.setVisible(var, visible);
                    }
                    continue;
                }
                blockInfo = workFlow.addBlock(-1, block, new Point(xPos, yPos));
                varRoot = XMLUtil.getElement(blockNode, "variables");
                inVarRoot = XMLUtil.getElement(varRoot, "input");
                for (Element element : XMLUtil.getElements(inVarRoot)) {
                    int id = XMLUtil.getAttributeIntValue(element, "ID", -1);
                    Var var = blockInfo.inputVars.get(id);
                    var.loadFromXML(element);
                    blockInfo.inputVars.setVisible(var, XMLUtil.getAttributeBooleanValue(element, "visible", false));
                }
                outVarRoot = XMLUtil.getElement(varRoot, "output");
                for (Element varNode : XMLUtil.getElements((Node)outVarRoot)) {
                    int id = XMLUtil.getAttributeIntValue(varNode, "ID", -1);
                    Var var = blockInfo.outputVars.get(id);
                    var.loadFromXML(varNode);
                    blockInfo.outputVars.setVisible(var, XMLUtil.getAttributeBooleanValue(varNode, "visible", false));
                }
            }
            catch (Exception e1) {
                throw new BlocksException("Cannot create block (" + e1.getMessage() + ")", true);
            }
        }
        Element linkRoot = XMLUtil.getElement(workFlowRoot, "links");
        for (Element linkNode : XMLUtil.getElements(linkRoot)) {
            int srcBlockID = XMLUtil.getAttributeIntValue(linkNode, "srcBlockID", -1);
            int srcVarID = XMLUtil.getAttributeIntValue(linkNode, "srcVarID", -1);
            int dstBlockID = XMLUtil.getAttributeIntValue(linkNode, "dstBlockID", -1);
            int dstVarID = XMLUtil.getAttributeIntValue(linkNode, "dstVarID", -1);
            BlockDescriptor srcBlock = workFlow.getBlock(srcBlockID);
            Var srcVar = srcBlock.outputVars.get(srcVarID);
            BlockDescriptor dstBlock = workFlow.getBlock(dstBlockID);
            Var dstVar = dstBlock.inputVars.get(dstVarID);
            workFlow.addLink(srcBlock, srcVar, dstBlock, dstVar);
        }
    }

    @Deprecated
    public synchronized void loadWorkFlow_V2(Element workFlowRoot, WorkFlow workFlow) {
        Element blocksRoot = XMLUtil.getElement(workFlowRoot, "blocks");
        ArrayList<Element> blocksNode = XMLUtil.getElements(blocksRoot);
        for (Element blockNode : blocksNode) {
            String className = XMLUtil.getAttributeValue(blockNode, "type", null);
            int xPos = XMLUtil.getAttributeIntValue(blockNode, "xLocation", -1);
            int yPos = XMLUtil.getAttributeIntValue(blockNode, "yLocation", -1);
            try {
                String uid;
                Object outVarRoot;
                Var var;
                Element inVarRoot;
                Element varRoot;
                BlockDescriptor blockInfo;
                Class<?> blockClass = ClassUtil.findClass(className);
                Block block = (Block)blockClass.newInstance();
                if (block == null) {
                    throw new BlocksException("Couldn't create block from class " + blockClass.getName(), true);
                }
                if (block instanceof WorkFlow) {
                    blockInfo = workFlow.addBlock(-1, block, new Point(xPos, yPos));
                    this.loadWorkFlow_V2(blockNode, (WorkFlow)block);
                    varRoot = XMLUtil.getElement(blockNode, "variables");
                    inVarRoot = XMLUtil.getElement(varRoot, "input");
                    for (Element element : XMLUtil.getElements(inVarRoot)) {
                        String uid2 = XMLUtil.getAttributeValue(element, "ID", null);
                        var = blockInfo.inputVars.get(uid2);
                        boolean visible = XMLUtil.getAttributeBooleanValue(element, "visible", false);
                        blockInfo.inputVars.setVisible(var, visible);
                    }
                    outVarRoot = XMLUtil.getElement(varRoot, "output");
                    for (Element varNode : XMLUtil.getElements((Node)outVarRoot)) {
                        uid = XMLUtil.getAttributeValue(varNode, "ID", null);
                        Var var2 = blockInfo.outputVars.get(uid);
                        boolean visible = XMLUtil.getAttributeBooleanValue(varNode, "visible", false);
                        blockInfo.outputVars.setVisible(var2, visible);
                    }
                    continue;
                }
                blockInfo = workFlow.addBlock(-1, block, new Point(xPos, yPos));
                varRoot = XMLUtil.getElement(blockNode, "variables");
                inVarRoot = XMLUtil.getElement(varRoot, "input");
                for (Element element : XMLUtil.getElements(inVarRoot)) {
                    String type;
                    String uid2 = XMLUtil.getAttributeValue(element, "ID", null);
                    var = blockInfo.inputVars.get(uid2);
                    var.loadFromXML(element);
                    blockInfo.inputVars.setVisible(var, XMLUtil.getAttributeBooleanValue(element, "visible", false));
                    if (!(var instanceof MutableType) || (type = XMLUtil.getAttributeValue(element, "type", null)) == null) continue;
                    if (var instanceof VarMutable) {
                        ((MutableType)((Object)var)).setType(Class.forName(type));
                        continue;
                    }
                    if (!(var instanceof VarMutableArray)) continue;
                    ((MutableType)((Object)var)).setType(Class.forName("[L" + type + ";"));
                }
                outVarRoot = XMLUtil.getElement(varRoot, "output");
                for (Element varNode3 : XMLUtil.getElements((Node)outVarRoot)) {
                    String type;
                    uid = XMLUtil.getAttributeValue(varNode3, "ID", null);
                    Var var3 = blockInfo.outputVars.get(uid);
                    var3.loadFromXML(varNode3);
                    blockInfo.outputVars.setVisible(var3, XMLUtil.getAttributeBooleanValue(varNode3, "visible", false));
                    if (!(var3 instanceof MutableType) || (type = XMLUtil.getAttributeValue(varNode3, "type", null)) == null) continue;
                    if (var3 instanceof VarMutable) {
                        ((MutableType)((Object)var3)).setType(Class.forName(type));
                        continue;
                    }
                    if (!(var3 instanceof VarMutableArray)) continue;
                    ((MutableType)((Object)var3)).setType(Class.forName("[L" + type + ";"));
                }
            }
            catch (Exception e1) {
                throw new BlocksException("Cannot create block (" + e1.getMessage() + ")", true);
            }
        }
        Element linkRoot = XMLUtil.getElement(workFlowRoot, "links");
        for (Element linkNode : XMLUtil.getElements(linkRoot)) {
            int srcBlockID = XMLUtil.getAttributeIntValue(linkNode, "srcBlockID", -1);
            String srcVarID = XMLUtil.getAttributeValue(linkNode, "srcVarID", null);
            int dstBlockID = XMLUtil.getAttributeIntValue(linkNode, "dstBlockID", -1);
            String dstVarID = XMLUtil.getAttributeValue(linkNode, "dstVarID", null);
            BlockDescriptor srcBlock = workFlow.getBlock(srcBlockID);
            Var srcVar = srcBlock.outputVars.get(srcVarID);
            if (srcVar == null) {
                srcVar = srcBlock.inputVars.get(srcVarID);
            }
            BlockDescriptor dstBlock = workFlow.getBlock(dstBlockID);
            Var dstVar = dstBlock.inputVars.get(dstVarID);
            workFlow.addLink(srcBlock, srcVar, dstBlock, dstVar);
        }
    }

    @Deprecated
    public synchronized void loadWorkFlow_V3(Element workFlowRoot, WorkFlow workFlow) {
        Element blocksRoot = XMLUtil.getElement(workFlowRoot, "blocks");
        ArrayList<Element> blocksNode = XMLUtil.getElements(blocksRoot);
        for (Element blockNode : blocksNode) {
            String blockType = XMLUtil.getAttributeValue(blockNode, "blockType", null);
            int xPos = XMLUtil.getAttributeIntValue(blockNode, "xLocation", -1);
            int yPos = XMLUtil.getAttributeIntValue(blockNode, "yLocation", -1);
            try {
                Class<?> blockClass = ClassUtil.findClass(blockType);
                Block block = (Block)blockClass.newInstance();
                if (block == null) {
                    throw new BlocksException("Couldn't create block from class " + blockClass.getName(), true);
                }
                if (block instanceof WorkFlow) {
                    int width = XMLUtil.getAttributeIntValue(blockNode, "width", 500);
                    int height = XMLUtil.getAttributeIntValue(blockNode, "height", 500);
                    ((WorkFlow)block).getBlockDescriptor().setDimension(width, height);
                    BlockDescriptor blockInfo = workFlow.addBlock(-1, block, new Point(xPos, yPos));
                    this.loadWorkFlow_V3(blockNode, (WorkFlow)block);
                    Element varRoot = XMLUtil.getElement(blockNode, "variables");
                    Element inVarRoot = XMLUtil.getElement(varRoot, "input");
                    for (Element element : XMLUtil.getElements(inVarRoot)) {
                        String uid = XMLUtil.getAttributeValue(element, "ID", null);
                        Var var = blockInfo.inputVars.get(uid);
                        boolean visible = XMLUtil.getAttributeBooleanValue(element, "visible", false);
                        blockInfo.inputVars.setVisible(var, visible);
                    }
                    Element outVarRoot = XMLUtil.getElement(varRoot, "output");
                    for (Element varNode3 : XMLUtil.getElements(outVarRoot)) {
                        String uid = XMLUtil.getAttributeValue(varNode3, "ID", null);
                        Var var = blockInfo.outputVars.get(uid);
                        boolean visible = XMLUtil.getAttributeBooleanValue(varNode3, "visible", false);
                        blockInfo.outputVars.setVisible(var, visible);
                    }
                    continue;
                }
                BlockDescriptor blockInfo = workFlow.addBlock(-1, block, new Point(xPos, yPos));
                Element varRoot = XMLUtil.getElement(blockNode, "variables");
                Element inVarRoot = XMLUtil.getElement(varRoot, "input");
                for (Element varNode : XMLUtil.getElements(inVarRoot)) {
                    String type;
                    String uid = XMLUtil.getAttributeValue(varNode, "ID", null);
                    Var var = blockInfo.inputVars.get(uid);
                    var.loadFromXML(varNode);
                    blockInfo.inputVars.setVisible(var, XMLUtil.getAttributeBooleanValue(varNode, "visible", false));
                    if (!(var instanceof MutableType) || (type = XMLUtil.getAttributeValue(varNode, "type", null)) == null) continue;
                    if (var instanceof VarMutable) {
                        ((MutableType)((Object)var)).setType(Class.forName(type));
                        continue;
                    }
                    if (!(var instanceof VarMutableArray)) continue;
                    ((MutableType)((Object)var)).setType(Class.forName("[L" + type + ";"));
                }
                Element outVarRoot = XMLUtil.getElement(varRoot, "output");
                for (Element varNode : XMLUtil.getElements(outVarRoot)) {
                    String type;
                    String string = XMLUtil.getAttributeValue(varNode, "ID", null);
                    Var var = blockInfo.outputVars.get(string);
                    var.loadFromXML(varNode);
                    blockInfo.outputVars.setVisible(var, XMLUtil.getAttributeBooleanValue(varNode, "visible", false));
                    if (!(var instanceof MutableType) || (type = XMLUtil.getAttributeValue(varNode, "type", null)) == null) continue;
                    if (var instanceof VarMutable) {
                        ((MutableType)((Object)var)).setType(Class.forName(type));
                        continue;
                    }
                    if (!(var instanceof VarMutableArray)) continue;
                    ((MutableType)((Object)var)).setType(Class.forName("[L" + type + ";"));
                }
            }
            catch (Exception e1) {
                throw new BlocksException("Cannot create block (" + e1.getMessage() + ")", true);
            }
        }
        Element linkRoot = XMLUtil.getElement(workFlowRoot, "links");
        for (Element linkNode : XMLUtil.getElements(linkRoot)) {
            int srcBlockID = XMLUtil.getAttributeIntValue(linkNode, "srcBlockID", -1);
            String srcVarID = XMLUtil.getAttributeValue(linkNode, "srcVarID", null);
            int dstBlockID = XMLUtil.getAttributeIntValue(linkNode, "dstBlockID", -1);
            String dstVarID = XMLUtil.getAttributeValue(linkNode, "dstVarID", null);
            BlockDescriptor srcBlock = workFlow.getBlock(srcBlockID);
            Var srcVar = srcBlock.outputVars.get(srcVarID);
            if (srcVar == null) {
                srcVar = srcBlock.inputVars.get(srcVarID);
            }
            BlockDescriptor dstBlock = workFlow.getBlock(dstBlockID);
            Var dstVar = dstBlock.inputVars.get(dstVarID);
            workFlow.addLink(srcBlock, srcVar, dstBlock, dstVar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadWorkFlow_V4(Element workFlowRoot, final WorkFlow workFlow) throws BlocksException {
        boolean hasWarnings = false;
        ArrayList<BlockDescriptor> blocksToCollapse = new ArrayList<BlockDescriptor>();
        Element blocksRoot = XMLUtil.getElement(workFlowRoot, "blocks");
        ArrayList<Element> blocksNode = XMLUtil.getElements(blocksRoot);
        for (Element blockNode : blocksNode) {
            VarMutable var;
            ArrayList<Element> outVarNodes;
            Object outVarRoot;
            Object uid;
            ArrayList<Element> inVarNodes;
            Element inVarRoot;
            Element varRoot;
            BlockDescriptor blockDescriptor;
            Block block;
            final String blockType = XMLUtil.getAttributeValue(blockNode, "blockType", null);
            Object var10_11 = null;
            try {
                block = ThreadUtil.invokeNow(new Callable<Block>(){

                    @Override
                    public Block call() throws Exception {
                        return (Block)ClassUtil.findClass(blockType).newInstance();
                    }
                });
            }
            catch (Exception e) {
                String message = "Couldn't create block from class \"" + blockType + "\".\n";
                message = message + "Reason: " + e.getClass().getName() + " (" + e.getMessage() + ")";
                throw new BlocksException(message, true);
            }
            int blockID = XMLUtil.getAttributeIntValue(blockNode, "ID", -1);
            if (block instanceof WorkFlow) {
                blockDescriptor = ((WorkFlow)block).getBlockDescriptor();
                blockDescriptor.setID(blockID);
            } else {
                blockDescriptor = new BlockDescriptor(blockID, block);
            }
            int xPos = XMLUtil.getAttributeIntValue(blockNode, "xLocation", -1);
            int yPos = XMLUtil.getAttributeIntValue(blockNode, "yLocation", -1);
            blockDescriptor.setLocation(xPos, yPos);
            int width = XMLUtil.getAttributeIntValue(blockNode, "width", 0);
            int height = XMLUtil.getAttributeIntValue(blockNode, "height", 0);
            blockDescriptor.setDimension(width, height);
            String definedName = XMLUtil.getAttributeValue(blockNode, "definedName", null);
            blockDescriptor.setDefinedName(definedName);
            blockDescriptor.keepResults(XMLUtil.getAttributeBooleanValue(blockNode, "keepsResults", true));
            if (block instanceof InputBlock || block instanceof OutputBlock) {
                blockDescriptor.setCommandLineID(XMLUtil.getAttributeValue(blockNode, "CommandLineID", ""));
            }
            workFlow.addBlock(blockDescriptor);
            if (block instanceof WorkFlow) {
                this.loadWorkFlow_V4(blockNode, (WorkFlow)block);
                varRoot = XMLUtil.getElement(blockNode, "variables");
                inVarRoot = XMLUtil.getElement(varRoot, "input");
                inVarNodes = XMLUtil.getElements(inVarRoot);
                VarList varList = blockDescriptor.inputVars;
                synchronized (varList) {
                    for (Element element : inVarNodes) {
                        uid = XMLUtil.getAttributeValue(element, "ID", null);
                        Var var2 = blockDescriptor.inputVars.get((String)uid);
                        if (var2 == null) {
                            System.err.println(new NoSuchVariableException(blockDescriptor, (String)uid).getMessage());
                            continue;
                        }
                        if (var2.getReference() != null) continue;
                        var2.loadFromXML(element);
                        boolean visible = XMLUtil.getAttributeBooleanValue(element, "visible", false);
                        try {
                            blockDescriptor.inputVars.setVisible(var2, visible);
                        }
                        catch (NoSuchVariableException e) {
                            if (!hasWarnings) {
                                System.err.println("Error(s) while loading protocol:");
                                hasWarnings = true;
                            }
                            System.err.println(new NoSuchVariableException(blockDescriptor, (String)uid).getMessage());
                        }
                    }
                }
                outVarRoot = XMLUtil.getElement(varRoot, "output");
                outVarNodes = XMLUtil.getElements((Node)outVarRoot);
                VarList varList2 = blockDescriptor.outputVars;
                synchronized (varList2) {
                    for (Element varNode : outVarNodes) {
                        String uid2 = XMLUtil.getAttributeValue(varNode, "ID", null);
                        var = blockDescriptor.outputVars.get(uid2);
                        boolean visible = XMLUtil.getAttributeBooleanValue(varNode, "visible", false);
                        try {
                            blockDescriptor.outputVars.setVisible(var, visible);
                        }
                        catch (NoSuchVariableException e) {
                            if (!hasWarnings) {
                                System.err.println("Error(s) while loading protocol:");
                                hasWarnings = true;
                            }
                            System.err.println(new NoSuchVariableException(blockDescriptor, uid2).getMessage());
                        }
                    }
                }
            }
            varRoot = XMLUtil.getElement(blockNode, "variables");
            inVarRoot = XMLUtil.getElement(varRoot, "input");
            inVarNodes = XMLUtil.getElements(inVarRoot);
            outVarRoot = blockDescriptor.inputVars;
            synchronized (outVarRoot) {
                for (Element element : inVarNodes) {
                    uid = XMLUtil.getAttributeValue(element, "ID", null);
                    VarMutable var2 = blockDescriptor.inputVars.get((String)uid);
                    boolean isDynamicVariable = XMLUtil.getAttributeBooleanValue(element, RUNTIME, false);
                    if (var2 == null) {
                        if (isDynamicVariable) {
                            var2 = new VarMutable(XMLUtil.getAttributeValue(element, "name", "input"), null);
                            var2.setDefaultEditorModel((VarEditorModel)new TypeSelectionModel());
                            blockDescriptor.inputVars.addRuntimeVariable((String)uid, var2);
                        } else {
                            if (!hasWarnings) {
                                System.err.println("Error(s) while loading protocol:");
                                hasWarnings = true;
                            }
                            System.err.println(new NoSuchVariableException(blockDescriptor, (String)uid).getMessage());
                            continue;
                        }
                    }
                    try {
                        Map<String, String> map;
                        String clID;
                        if (var2 instanceof MutableType) {
                            Class<?> mutableType = null;
                            String type = XMLUtil.getAttributeValue(element, "type", null);
                            if (type != null) {
                                if (var2 instanceof VarMutable) {
                                    mutableType = BlocksML.getPrimitiveType(type);
                                    if (mutableType == null) {
                                        mutableType = Class.forName(type);
                                    }
                                } else if (var2 instanceof VarMutableArray) {
                                    mutableType = Class.forName("[L" + type + ";");
                                }
                                ((MutableType)var2).setType(mutableType);
                            }
                        }
                        var2.loadFromXML(element);
                        if (block instanceof InputBlock && !(clID = blockDescriptor.getCommandLineID()).isEmpty() && (map = Protocols.getCommandLineArguments()).containsKey(clID)) {
                            var2.setValueAsString(map.get(clID));
                        }
                    }
                    catch (Exception e) {
                        String message = "Unable to read input variable \"" + var2.getName() + "\" in block \"" + blockDescriptor.getDefinedName() + "\".\n";
                        message = message + "Reason: " + e.getClass().getName() + " (" + e.getMessage() + ")";
                        throw new BlocksException(message, true);
                    }
                    blockDescriptor.inputVars.setVisible(var2, XMLUtil.getAttributeBooleanValue(element, "visible", false));
                }
            }
            outVarRoot = XMLUtil.getElement(varRoot, "output");
            outVarNodes = XMLUtil.getElements((Node)outVarRoot);
            VarList varList = blockDescriptor.outputVars;
            synchronized (varList) {
                for (Element varNode3 : outVarNodes) {
                    String uid3 = XMLUtil.getAttributeValue(varNode3, "ID", null);
                    var = blockDescriptor.outputVars.get(uid3);
                    boolean isDynamicVariable = XMLUtil.getAttributeBooleanValue(varNode3, RUNTIME, false);
                    if (var == null) {
                        if (isDynamicVariable) {
                            var = new VarMutable(XMLUtil.getAttributeValue(varNode3, "name", "output"), null);
                            var.setDefaultEditorModel((VarEditorModel)new TypeSelectionModel());
                            blockDescriptor.outputVars.addRuntimeVariable(uid3, var);
                        } else {
                            if (!hasWarnings) {
                                System.err.println("Error(s) while loading protocol:");
                                hasWarnings = true;
                            }
                            System.err.println(new NoSuchVariableException(blockDescriptor, uid3).getMessage());
                            continue;
                        }
                    }
                    blockDescriptor.outputVars.setVisible(var, XMLUtil.getAttributeBooleanValue(varNode3, "visible", false));
                    if (!(var instanceof MutableType)) continue;
                    try {
                        String type = XMLUtil.getAttributeValue(varNode3, "type", null);
                        if (type == null) continue;
                        if (var instanceof VarMutable) {
                            Class<?> mutableType = BlocksML.getPrimitiveType(type);
                            ((MutableType)var).setType(mutableType != null ? mutableType : Class.forName(type));
                            continue;
                        }
                        if (!(var instanceof VarMutableArray)) continue;
                        ((MutableType)var).setType(Class.forName("[L" + type + ";"));
                    }
                    catch (ClassNotFoundException e) {
                        String message = "Unable to read output variable \"" + var.getName() + "\" in block \"" + blockDescriptor.getDefinedName() + "\".\n";
                        message = message + "Reason: " + e.getClass().getName() + " (" + e.getMessage() + ")";
                        throw new BlocksException(message, true);
                    }
                }
            }
            if (!XMLUtil.getAttributeBooleanValue(blockNode, "collapsed", false)) continue;
            blocksToCollapse.add(blockDescriptor);
        }
        Element linkRoot = XMLUtil.getElement(workFlowRoot, "links");
        ArrayList<Element> links = XMLUtil.getElements(linkRoot);
        Collections.sort(links, new Comparator<Element>(){

            @Override
            public int compare(Element link1, Element link2) {
                int i2;
                int srcBlock1 = XMLUtil.getAttributeIntValue(link1, "srcBlockID", -1);
                int srcBlock2 = XMLUtil.getAttributeIntValue(link2, "srcBlockID", -1);
                int i1 = workFlow.indexOf(workFlow.getBlockByID(srcBlock1));
                return i1 < (i2 = workFlow.indexOf(workFlow.getBlockByID(srcBlock2))) ? -1 : (i1 > i2 ? 1 : 0);
            }
        });
        for (Element element : links) {
            String type;
            int srcBlockID = XMLUtil.getAttributeIntValue(element, "srcBlockID", -1);
            String srcVarID = XMLUtil.getAttributeValue(element, "srcVarID", null);
            int dstBlockID = XMLUtil.getAttributeIntValue(element, "dstBlockID", -1);
            String dstVarID = XMLUtil.getAttributeValue(element, "dstVarID", null);
            BlockDescriptor srcBlock = workFlow.getBlockByID(srcBlockID);
            Var srcVar = srcBlock.outputVars.get(srcVarID);
            if (srcVar == null) {
                srcVar = srcBlock.inputVars.get(srcVarID);
            }
            if (srcVar == null) {
                System.err.println("Cannot create a link from variable " + srcVarID + " (from block " + srcBlock + "). It may have been removed or renamed.");
                continue;
            }
            if (srcVar instanceof MutableType && (type = XMLUtil.getAttributeValue(element, "srcVarType", null)) != null) {
                try {
                    if (srcVar instanceof VarMutable) {
                        Class<?> mutableType = BlocksML.getPrimitiveType(type);
                        ((MutableType)((Object)srcVar)).setType(mutableType != null ? mutableType : Class.forName(type));
                    } else if (srcVar instanceof VarMutableArray) {
                        ((MutableType)((Object)srcVar)).setType(Class.forName("[L" + type + ";"));
                    }
                }
                catch (ClassNotFoundException e1) {
                    throw new BlocksException("Cannot create block (" + e1.getMessage() + ") => class not found", true);
                }
            }
            BlockDescriptor dstBlock = workFlow.getBlockByID(dstBlockID);
            Var dstVar = dstBlock.inputVars.get(dstVarID);
            if (dstVar == null) {
                System.err.println("Cannot link to variable " + dstVarID + " (from block " + dstBlock + "). It may have been removed or renamed.");
                continue;
            }
            workFlow.addLink(srcBlock, srcVar, dstBlock, dstVar);
        }
        for (BlockDescriptor blockDescriptor : blocksToCollapse) {
            blockDescriptor.setCollapsed(true);
        }
        if (hasWarnings) {
            System.err.println("--");
        }
    }

    public synchronized void loadWorkFlow_V5(Element workFlowRoot, WorkFlow workFlow, WorkFlow parentFlow) throws BlocksException {
        boolean noWarnings = true;
        Element blocksRoot = XMLUtil.getElement(workFlowRoot, "blocks");
        ArrayList<Element> blocksNode = XMLUtil.getElements(blocksRoot);
        for (Element blockNode : blocksNode) {
            BlockDescriptor blockDesc = new BlockDescriptor();
            noWarnings &= blockDesc.loadFromXML(blockNode);
            workFlow.addBlock(blockDesc);
        }
        Element linkRoot = XMLUtil.getElement(workFlowRoot, "links");
        for (Element linkNode : XMLUtil.getElements(linkRoot)) {
            Link link = new Link(workFlow);
            link.loadFromXML(linkNode);
        }
        if (!noWarnings) {
            System.err.println("--");
        }
    }

    public static Class<?> getPrimitiveType(String primitiveName) {
        if (primitiveName.equals("byte")) {
            return Byte.TYPE;
        }
        if (primitiveName.equals("short")) {
            return Short.TYPE;
        }
        if (primitiveName.equals("int")) {
            return Integer.TYPE;
        }
        if (primitiveName.equals("long")) {
            return Long.TYPE;
        }
        if (primitiveName.equals("char")) {
            return Character.TYPE;
        }
        if (primitiveName.equals("float")) {
            return Float.TYPE;
        }
        if (primitiveName.equals("double")) {
            return Double.TYPE;
        }
        if (primitiveName.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (primitiveName.equals("void")) {
            return Void.TYPE;
        }
        return null;
    }
}

