/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.ezplug;

import icy.system.thread.ThreadUtil;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import plugins.adufour.ezplug.EzComponent;

public class EzPanel
extends EzComponent
implements Iterable<EzComponent> {
    private final List<EzComponent> components;
    protected JComponent container;
    protected String toolTipText = "";

    public EzPanel(String name, EzComponent ... ezComponents) {
        super(name);
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                EzPanel.this.container = EzPanel.this.createContainer();
            }
        }, !SwingUtilities.isEventDispatchThread());
        this.components = new EzComponentList(ezComponents.length);
        this.add(ezComponents);
    }

    protected JComponent createContainer() {
        return new JPanel(new GridBagLayout());
    }

    public void add(EzComponent ... ezComponents) {
        if (ezComponents == null || ezComponents.length == 0) {
            return;
        }
        for (EzComponent ezComponent : ezComponents) {
            this.components.add(ezComponent);
        }
    }

    @Override
    public Iterator<EzComponent> iterator() {
        return this.components.iterator();
    }

    protected void buildPanel() {
        this.container.removeAll();
        for (EzComponent ezComponent : this.components) {
            if (!ezComponent.isVisible()) continue;
            ezComponent.addTo(this.container);
        }
    }

    @Override
    protected void addTo(Container parentContainer) {
        this.buildPanel();
        GridBagLayout gridbag = (GridBagLayout)parentContainer.getLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gridbag.setConstraints(this.container, gbc);
        parentContainer.add(this.container);
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    @Override
    public void setToolTipText(String text) {
        this.toolTipText = text;
    }

    @Override
    protected void dispose() {
        for (EzComponent ezComponent : this.components) {
            ezComponent.dispose();
        }
        this.components.clear();
        super.dispose();
    }

    private class EzComponentList
    extends ArrayList<EzComponent> {
        public EzComponentList(int initialSize) {
            super(initialSize);
        }

        @Override
        public boolean add(EzComponent e) {
            e.setParentPanel(EzPanel.this);
            return super.add(e);
        }

        @Override
        public void add(int index, EzComponent element) {
            element.setParentPanel(EzPanel.this);
            super.add(index, element);
        }

        @Override
        public boolean addAll(Collection<? extends EzComponent> c) {
            for (EzComponent ezComponent : c) {
                ezComponent.setParentPanel(EzPanel.this);
            }
            return super.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends EzComponent> c) {
            for (EzComponent ezComponent : c) {
                ezComponent.setParentPanel(EzPanel.this);
            }
            return super.addAll(index, c);
        }

        @Override
        public void clear() {
            for (EzComponent comp : this) {
                comp.setParentPanel(null);
            }
            super.clear();
        }

        @Override
        public EzComponent remove(int index) {
            EzComponent oldElement = (EzComponent)super.remove(index);
            if (oldElement != null) {
                oldElement.setParentPanel(null);
            }
            return oldElement;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (this.get(i) == null) continue;
                ((EzComponent)this.get(i)).setParentPanel(null);
            }
            super.removeRange(fromIndex, toIndex);
        }

        @Override
        public EzComponent set(int index, EzComponent element) {
            element.setParentPanel(EzPanel.this);
            EzComponent oldElement = super.set(index, element);
            if (oldElement != null) {
                oldElement.setParentPanel(null);
            }
            return oldElement;
        }
    }
}

