/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.ezplug;

import icy.util.XMLUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import plugins.adufour.ezplug.EzException;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVar;

class EzVarIO {
    EzVarIO() {
    }

    static synchronized void save(EzPlug source, HashMap<String, EzVar<?>> ezVarMap, File f) {
        Document xml = XMLUtil.createDocument(false);
        Element root = XMLUtil.createRootElement(xml, "Parameters");
        for (String id : ezVarMap.keySet()) {
            EzVar<?> var = ezVarMap.get(id);
            try {
                Element parameterNode = XMLUtil.addElement(root, "parameter");
                XMLUtil.setAttributeValue(parameterNode, "ID", id);
                var.getVariable().saveToXML(parameterNode);
            }
            catch (UnsupportedOperationException e) {
                System.err.println("Warning: variable " + id + " has not been saved (unsupported variable type)");
            }
        }
        if (!XMLUtil.saveDocument(xml, f)) {
            throw new EzException(source, "unable to save parameters", true);
        }
    }

    static synchronized void load(EzPlug source, File f, HashMap<String, EzVar<?>> ezVarMap) throws EzException {
        Document xml = XMLUtil.loadDocument(f);
        if (xml == null) {
            throw new EzException(source, "unable to load parameter file", true);
        }
        Element root = XMLUtil.getRootElement(xml);
        ArrayList<Element> elements = XMLUtil.getElements(root);
        for (Element element : elements) {
            String id = XMLUtil.getAttributeValue(element, "ID", null);
            if (id == null || !ezVarMap.containsKey(id)) continue;
            ezVarMap.get(id).getVariable().loadFromXML(element);
        }
    }
}

