/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.model;

import plugins.adufour.vars.gui.model.RangeModel;

public class FloatRangeModel
extends RangeModel<Float> {
    public FloatRangeModel(Float defaultValue, Float min, Float max, Float step) {
        this(defaultValue, min, max, step, RangeModel.RangeEditorType.SPINNER);
    }

    public FloatRangeModel(Float defaultValue, Float min, Float max, Float step, RangeModel.RangeEditorType editorType) {
        super(defaultValue, min, max, step, editorType, null);
    }

    @Override
    public boolean isValid(Float value) {
        return this.min.compareTo(value) <= 0 && this.max.compareTo(value) >= 0 && value.floatValue() % ((Float)this.step).floatValue() == 0.0f;
    }

    @Override
    public int getRangeSize() {
        return Math.round((((Float)this.max).floatValue() - ((Float)this.min).floatValue()) / ((Float)this.step).floatValue());
    }

    @Override
    public Float getValueForIndex(int index) {
        return Float.valueOf(((Float)this.min).floatValue() + (float)index * ((Float)this.step).floatValue());
    }

    @Override
    public int indexOf(Float value) {
        return Math.round((value.floatValue() - ((Float)this.min).floatValue()) / ((Float)this.step).floatValue());
    }
}

