/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.property;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginROIDescriptor;
import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.type.rectangle.Rectangle5D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import plugins.kernel.roi.descriptor.property.ROISizeCDescriptor;
import plugins.kernel.roi.descriptor.property.ROISizeTDescriptor;
import plugins.kernel.roi.descriptor.property.ROISizeXDescriptor;
import plugins.kernel.roi.descriptor.property.ROISizeYDescriptor;
import plugins.kernel.roi.descriptor.property.ROISizeZDescriptor;

public class ROISizeDescriptorsPlugin
extends Plugin
implements PluginROIDescriptor {
    public static final String ID_SIZE_X = "Size X";
    public static final String ID_SIZE_Y = "Size Y";
    public static final String ID_SIZE_Z = "Size Z";
    public static final String ID_SIZE_T = "Size T";
    public static final String ID_SIZE_C = "Size C";
    public static final ROISizeXDescriptor sizeXDescriptor = new ROISizeXDescriptor();
    public static final ROISizeYDescriptor sizeYDescriptor = new ROISizeYDescriptor();
    public static final ROISizeZDescriptor sizeZDescriptor = new ROISizeZDescriptor();
    public static final ROISizeTDescriptor sizeTDescriptor = new ROISizeTDescriptor();
    public static final ROISizeCDescriptor sizeCDescriptor = new ROISizeCDescriptor();

    @Override
    public List<ROIDescriptor> getDescriptors() {
        ArrayList<ROIDescriptor> result = new ArrayList<ROIDescriptor>();
        result.add(sizeXDescriptor);
        result.add(sizeYDescriptor);
        result.add(sizeZDescriptor);
        result.add(sizeTDescriptor);
        result.add(sizeCDescriptor);
        return result;
    }

    @Override
    public Map<ROIDescriptor, Object> compute(ROI roi, Sequence sequence) throws UnsupportedOperationException {
        HashMap<ROIDescriptor, Object> result = new HashMap<ROIDescriptor, Object>();
        try {
            Rectangle5D size = roi.getBounds5D();
            result.put(sizeXDescriptor, ROISizeXDescriptor.getSizeX(size));
            result.put(sizeYDescriptor, ROISizeYDescriptor.getSizeY(size));
            result.put(sizeZDescriptor, ROISizeZDescriptor.getSizeZ(size));
            result.put(sizeTDescriptor, ROISizeTDescriptor.getSizeT(size));
            result.put(sizeCDescriptor, ROISizeCDescriptor.getSizeC(size));
        }
        catch (Exception e) {
            String mess = this.getClass().getSimpleName() + ": cannot compute descriptors for '" + roi.getName() + "'";
            throw new UnsupportedOperationException(mess, e);
        }
        return result;
    }
}

