/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi2d;

import icy.painter.Anchor2D;
import icy.painter.LineAnchor2D;
import icy.resource.ResourceUtil;
import icy.type.geom.Polygon2D;
import icy.type.point.Point5D;
import icy.util.XMLUtil;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class ROI2DPolygon
extends ROI2DShape {
    public static final String ID_POINTS = "points";
    public static final String ID_POINT = "point";

    @Deprecated
    public ROI2DPolygon(Point2D pt, boolean cm) {
        this(pt);
    }

    public ROI2DPolygon(Point2D pt) {
        super(new Polygon2D());
        Anchor2D point = this.createAnchor(pt);
        point.setSelected(true);
        this.addPoint(point);
        this.setIcon(ResourceUtil.ICON_ROI_POLYGON);
    }

    public ROI2DPolygon(Point5D pt) {
        this(pt.toPoint2D());
    }

    public ROI2DPolygon(List<Point2D> points) {
        this(new Point2D.Double());
        this.setPoints(points);
        this.unselectAllPoints();
    }

    @Deprecated
    public ROI2DPolygon(Polygon polygon) {
        this(new Point2D.Double());
        this.setPolygon(polygon);
        this.unselectAllPoints();
    }

    public ROI2DPolygon(Polygon2D polygon) {
        this(new Point2D.Double());
        this.setPolygon2D(polygon);
        this.unselectAllPoints();
    }

    public ROI2DPolygon() {
        this(new Point2D.Double());
    }

    @Override
    public String getDefaultName() {
        return "Polygon2D";
    }

    @Override
    protected Anchor2D createAnchor(Point2D pos) {
        return new ROI2DPolygonAnchor2D(pos, this.getColor(), this.getFocusedColor());
    }

    @Deprecated
    protected Path2D getPath() {
        return new Path2D.Double(this.shape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoints(List<Point2D> pts) {
        this.beginUpdate();
        try {
            List<Anchor2D> ctrlPts = this.getControlPoints();
            if (pts.size() == ctrlPts.size()) {
                for (int i = 0; i < pts.size(); ++i) {
                    Point2D newPt = pts.get(i);
                    Anchor2D pt = ctrlPts.get(i);
                    pt.setPosition(newPt.getX(), newPt.getY());
                }
            } else {
                this.removeAllPoint();
                for (Point2D pt : pts) {
                    this.addNewPoint(pt, false);
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Deprecated
    public void setPoints(ArrayList<Point2D> pts) {
        this.setPoints((List<Point2D>)pts);
    }

    public Polygon2D getPolygon2D() {
        return (Polygon2D)this.shape;
    }

    public void setPolygon2D(Polygon2D polygon2D) {
        this.setPoints(polygon2D.getPoints());
    }

    public Polygon getPolygon() {
        return this.getPolygon2D().getPolygon();
    }

    public void setPolygon(Polygon polygon) {
        this.setPolygon2D(new Polygon2D(polygon));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateShape() {
        Polygon2D polygon2d;
        double[] ptsY;
        double[] ptsX;
        int len;
        List list = this.controlPoints;
        synchronized (list) {
            len = this.controlPoints.size();
            ptsX = new double[len];
            ptsY = new double[len];
            for (int i = 0; i < len; ++i) {
                Anchor2D pt = (Anchor2D)this.controlPoints.get(i);
                ptsX[i] = pt.getX();
                ptsY[i] = pt.getY();
            }
        }
        Polygon2D polygon2D = polygon2d = this.getPolygon2D();
        synchronized (polygon2D) {
            polygon2d.npoints = len;
            polygon2d.xpoints = ptsX;
            polygon2d.ypoints = ptsY;
            polygon2d.calculatePath();
        }
        super.updateShape();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                boolean bl = false;
                return bl;
            }
            this.removeAllPoint();
            ArrayList<Node> nodesPoint = XMLUtil.getChildren(XMLUtil.getElement(node, ID_POINTS), ID_POINT);
            if (nodesPoint != null) {
                for (Node n : nodesPoint) {
                    Anchor2D pt = this.createAnchor(new Point2D.Double());
                    pt.loadPositionFromXML(n);
                    this.addPoint(pt);
                }
            }
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        Element nodePoints = XMLUtil.setElement(node, ID_POINTS);
        List list = this.controlPoints;
        synchronized (list) {
            for (Anchor2D pt : this.controlPoints) {
                pt.savePositionToXML(XMLUtil.addElement(nodePoints, ID_POINT));
            }
        }
        return true;
    }

    protected class ROI2DPolygonAnchor2D
    extends LineAnchor2D {
        public ROI2DPolygonAnchor2D(Point2D position, Color color, Color selectedColor) {
            super(position, color, selectedColor);
        }

        @Override
        protected Anchor2D getPreviousPoint() {
            int ind = ROI2DPolygon.this.controlPoints.indexOf(this);
            if (ind == 0) {
                if (ROI2DPolygon.this.controlPoints.size() > 1) {
                    return (Anchor2D)ROI2DPolygon.this.controlPoints.get(1);
                }
                return null;
            }
            if (ind != -1) {
                return (Anchor2D)ROI2DPolygon.this.controlPoints.get(ind - 1);
            }
            return null;
        }
    }
}

