/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.searchprovider;

import icy.action.ActionManager;
import icy.action.IcyAbstractAction;
import icy.resource.icon.IcyIcon;
import icy.search.SearchResult;
import icy.search.SearchResultConsumer;
import icy.search.SearchResultProducer;
import icy.util.StringUtil;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import org.pushingpixels.flamingo.api.common.RichTooltip;

public class KernelSearchResultProducer
extends SearchResultProducer {
    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public String getName() {
        return "Command";
    }

    @Override
    public String getTooltipText() {
        return "Result(s) from the internal commands and actions";
    }

    @Override
    public void doSearch(String text, SearchResultConsumer consumer) {
        List<SearchResultProducer.SearchWord> words = KernelSearchResultProducer.getSearchWords(text);
        if (words.isEmpty()) {
            return;
        }
        ArrayList<KernelSearchResult> tmpResults = new ArrayList<KernelSearchResult>();
        boolean startWithOnly = KernelSearchResultProducer.getShortSearch(words);
        for (IcyAbstractAction action : ActionManager.actions) {
            if (this.hasWaitingSearch()) {
                return;
            }
            int prio = KernelSearchResultProducer.searchInAction(action, words, startWithOnly);
            if (prio <= 0) continue;
            tmpResults.add(new KernelSearchResult(this, action, words, prio, startWithOnly));
        }
        this.results = tmpResults;
        consumer.resultsChanged(this);
    }

    public static int searchInAction(IcyAbstractAction action, List<SearchResultProducer.SearchWord> words, boolean startWithOnly) {
        int result = 0;
        for (SearchResultProducer.SearchWord sw : words) {
            int r = KernelSearchResultProducer.searchInAction(action, sw.word, startWithOnly);
            if (r == 0 && sw.mandatory) {
                return 0;
            }
            if (r > 0 && sw.reject) {
                return 0;
            }
            result += r;
        }
        return result / words.size();
    }

    public static int searchInAction(IcyAbstractAction action, String word, boolean startWithOnly) {
        String wordlc = word.trim().toLowerCase();
        String text = action.getDescription();
        if (!StringUtil.isEmpty(text) && text.toLowerCase().startsWith(wordlc)) {
            return 8;
        }
        text = action.getLongDescription();
        if (!StringUtil.isEmpty(text) && text.toLowerCase().startsWith(wordlc)) {
            return 5;
        }
        if (!startWithOnly) {
            text = action.getDescription();
            if (!StringUtil.isEmpty(text) && text.toLowerCase().contains(wordlc)) {
                return 7;
            }
            text = action.getLongDescription();
            if (!StringUtil.isEmpty(text) && text.toLowerCase().contains(wordlc)) {
                return 3;
            }
        }
        return 0;
    }

    public static class KernelSearchResult
    extends SearchResult {
        private final IcyAbstractAction action;
        private final int priority;
        private String description;

        public KernelSearchResult(SearchResultProducer provider, IcyAbstractAction action, List<SearchResultProducer.SearchWord> searchWords, int priority, boolean startWithOnly) {
            super(provider);
            this.action = action;
            this.priority = priority;
            String longDesc = action.getLongDescription();
            if (!StringUtil.isEmpty(longDesc)) {
                String[] lds = longDesc.split("\n");
                if (lds.length > 0) {
                    this.description = StringUtil.limit(lds[0], 80, true);
                }
                if (!startWithOnly) {
                    for (SearchResultProducer.SearchWord sw : searchWords) {
                        this.description = StringUtil.htmlBoldSubstring(this.description, sw.word, true);
                    }
                }
            } else {
                this.description = "";
            }
        }

        public IcyAbstractAction getAction() {
            return this.action;
        }

        @Override
        public Image getImage() {
            IcyIcon icon = this.action.getIcon();
            if (icon != null) {
                return icon.getImage();
            }
            return null;
        }

        @Override
        public String getTitle() {
            String desc = this.action.getDescription();
            if (!StringUtil.isEmpty(desc)) {
                return desc;
            }
            return this.action.getName();
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getTooltip() {
            if (this.isEnabled()) {
                return "Click to execute the action";
            }
            return "Inactive action";
        }

        @Override
        public boolean isEnabled() {
            return this.action.isEnabled();
        }

        @Override
        public void execute() {
            this.action.execute();
        }

        @Override
        public RichTooltip getRichToolTip() {
            String longDesc = this.action.getLongDescription();
            if (!StringUtil.isEmpty(longDesc) && longDesc.split("\n").length > 1) {
                return this.action.getRichToolTip();
            }
            return null;
        }

        @Override
        public void executeAlternate() {
        }

        @Override
        public int compareTo(SearchResult o) {
            if (o instanceof KernelSearchResult) {
                return ((KernelSearchResult)o).priority - this.priority;
            }
            return super.compareTo(o);
        }
    }
}

