/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui.workers;

import io.bioimage.modelrunner.gui.DefaultIcon;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class ImageLoaderWorker
extends SwingWorker<ImageIcon, Void> {
    private volatile URLConnection connection;
    private final URL url;
    private final int width;
    private final int height;
    private final ImageLoadCallback callback;

    private ImageLoaderWorker(URL url, int width, int height, ImageLoadCallback callback) {
        this.url = url;
        this.height = height;
        this.width = width;
        this.callback = callback;
    }

    public static void main(String[] args) throws MalformedURLException, InterruptedException, ExecutionException {
        URL url2 = new URL("https://fastly.picsum.photos/id/237/200/300.jpg?hmac=TmmQSbShHz9CdQm0NkEjx1Dyh_Y984R9LpNrpvH2D_U");
        URL url1 = new URL("https://upload.wikimedia.org/wikipedia/commons/9/94/Ti_cd2708n2l_mcmaster_mz_mit20x.jpg");
        ImageLoadCallback callback = new ImageLoadCallback(){

            @Override
            public void onImageLoaded(ImageIcon icon) {
            }
        };
        ImageLoaderWorker a1 = ImageLoaderWorker.create(url1, 100, 100, callback);
        ImageLoaderWorker a2 = ImageLoaderWorker.create(url2, 10, 10, callback);
        a1.execute();
        a2.execute();
        a2.get();
        Thread.sleep(100000L);
    }

    public static ImageLoaderWorker create(URL url, int width, int height, ImageLoadCallback callback) {
        return new ImageLoaderWorker(url, width, height, callback);
    }

    @Override
    protected ImageIcon doInBackground() throws Exception {
        this.connection = this.url.openConnection();
        if (this.connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)this.connection;
            httpConnection.setConnectTimeout(5000);
            httpConnection.setReadTimeout(5000);
        }
        try {
            ImageIcon imageIcon = this.createScaledIcon(this.connection, this.width, this.height);
            return imageIcon;
        }
        finally {
            if (this.connection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.connection).disconnect();
            }
        }
    }

    @Override
    protected void done() {
        try {
            if (this.isCancelled()) {
                return;
            }
            ImageIcon icon = (ImageIcon)this.get();
            if (icon == null) {
                return;
            }
            SwingUtilities.invokeLater(() -> this.callback.onImageLoaded(icon));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean cancelBackground() {
        if (this.connection != null && this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.connection).disconnect();
        }
        return this.cancel(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageIcon createScaledIcon(URL imagePath, int logoWidth, int logoHeight) {
        if (imagePath == null) {
            return DefaultIcon.getDefaultIcon(logoWidth, logoHeight);
        }
        try (ImageInputStream iis = ImageIO.createImageInputStream(imagePath.openStream());){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (!readers.hasNext()) {
                ImageIcon imageIcon = DefaultIcon.getDefaultIcon(logoWidth, logoHeight);
                return imageIcon;
            }
            ImageReader reader = readers.next();
            reader.setInput(iis);
            if (ImageLoaderWorker.isAnimatedGif(reader)) {
                ImageIcon imageIcon = ImageLoaderWorker.createScaledAnimatedGif(imagePath, logoWidth, logoHeight);
                return imageIcon;
            }
            ImageIcon imageIcon = ImageLoaderWorker.createScaledStaticImage(reader, logoWidth, logoHeight);
            return imageIcon;
        }
        catch (IOException e) {
            return DefaultIcon.getDefaultIcon(logoWidth, logoHeight);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ImageIcon createScaledIcon(URLConnection connection, int logoWidth, int logoHeight) {
        if (connection == null) {
            return DefaultIcon.getDefaultIcon(logoWidth, logoHeight);
        }
        try (ImageInputStream iis = ImageIO.createImageInputStream(connection.getInputStream());){
            if (this.isCancelled()) {
                ImageIcon imageIcon = null;
                return imageIcon;
            }
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (this.isCancelled()) {
                ImageIcon imageIcon = null;
                return imageIcon;
            }
            if (!readers.hasNext()) {
                ImageIcon imageIcon = DefaultIcon.getDefaultIcon(logoWidth, logoHeight);
                return imageIcon;
            }
            ImageReader reader = readers.next();
            reader.setInput(iis);
            if (this.isCancelled()) {
                ImageIcon imageIcon = null;
                return imageIcon;
            }
            if (ImageLoaderWorker.isAnimatedGif(reader)) {
                ImageIcon imageIcon = ImageLoaderWorker.createScaledAnimatedGif(connection.getURL(), logoWidth, logoHeight);
                return imageIcon;
            }
            ImageIcon imageIcon = ImageLoaderWorker.createScaledStaticImage(reader, logoWidth, logoHeight);
            return imageIcon;
        }
        catch (IOException e) {
            return DefaultIcon.getDefaultIcon(logoWidth, logoHeight);
        }
    }

    private static boolean isAnimatedGif(ImageReader reader) throws IOException {
        return reader.getFormatName().equalsIgnoreCase("gif") && reader.getNumImages(true) > 1;
    }

    private static ImageIcon createScaledAnimatedGif(URL imagePath, int width, int height) {
        ImageIcon originalIcon = new ImageIcon(imagePath);
        Image scaledImage = originalIcon.getImage().getScaledInstance(width, height, 4);
        return new ImageIcon(scaledImage);
    }

    private static ImageIcon createScaledStaticImage(ImageReader reader, int width, int height) throws IOException {
        BufferedImage originalImage = reader.read(0);
        if (originalImage == null) {
            return DefaultIcon.getDefaultIcon(width, height);
        }
        BufferedImage scaledImage = new BufferedImage(width, height, 2);
        AffineTransform at = AffineTransform.getScaleInstance((double)width / (double)originalImage.getWidth(), (double)height / (double)originalImage.getHeight());
        AffineTransformOp scaleOp = new AffineTransformOp(at, 1);
        scaleOp.filter(originalImage, scaledImage);
        return new ImageIcon(scaledImage);
    }

    public static ImageIcon createScaledStaticImage(URL imagePath, int width, int height) throws IOException {
        BufferedImage originalImage = ImageIO.read(imagePath);
        if (originalImage == null) {
            return DefaultIcon.getDefaultIcon(width, height);
        }
        BufferedImage scaledImage = new BufferedImage(width, height, 2);
        AffineTransform at = AffineTransform.getScaleInstance((double)width / (double)originalImage.getWidth(), (double)height / (double)originalImage.getHeight());
        AffineTransformOp scaleOp = new AffineTransformOp(at, 1);
        scaleOp.filter(originalImage, scaledImage);
        return new ImageIcon(scaledImage);
    }

    @FunctionalInterface
    public static interface ImageLoadCallback {
        public void onImageLoaded(ImageIcon var1);

        default public void onImageLoadFailed(Exception e) {
            System.err.println("Failed to load image: " + e.getMessage());
        }
    }
}

