/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.transformations;

import io.bioimage.modelrunner.tensor.Tensor;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;

public abstract class TensorTransformation {
    protected Mode mode = Mode.FIXED;

    public abstract <R extends RealType<R> & NativeType<R>> Tensor<FloatType> apply(Tensor<R> var1);

    public abstract <R extends RealType<R> & NativeType<R>> void applyInPlace(Tensor<R> var1);

    public abstract String getName();

    public void setMode(Object mode) {
        if (mode instanceof String) {
            this.mode = Mode.valueOf(((String)mode).toUpperCase());
        } else if (mode instanceof Mode) {
            this.mode = (Mode)((Object)mode);
        } else {
            throw new IllegalArgumentException("'mode' parameter has to be either and instance of " + String.class + " or " + Mode.class + ". The provided argument is an instance of: " + mode.getClass());
        }
    }

    public abstract Mode getMode();

    public static enum Mode {
        FIXED("fixed"),
        PER_DATASET("per_dataset"),
        PER_SAMPLE("per_sample");

        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

