/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.versionmanagement;

import io.bioimage.modelrunner.system.PlatformDetection;
import io.bioimage.modelrunner.versionmanagement.AvailableEngines;
import io.bioimage.modelrunner.versionmanagement.DeepLearningVersion;
import io.bioimage.modelrunner.versionmanagement.SupportedVersions;
import io.bioimage.modelrunner.versionmanagement.VersionStringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class InstalledEngines {
    private Path path;
    private static String ENGINES_FOLDER_NAME = "engines";

    private InstalledEngines(Path path) throws IOException {
        if (!path.toFile().isDirectory() && !path.toFile().mkdirs()) {
            throw new IOException("Unable to find or create Deep Learning engines directory: " + path.toString());
        }
        this.path = path;
    }

    public static InstalledEngines buildEnginesFinder() throws IOException {
        return new InstalledEngines(Paths.get(ENGINES_FOLDER_NAME, new String[0]).toAbsolutePath());
    }

    public static InstalledEngines buildEnginesFinder(String enginesDirectory) throws IOException {
        return new InstalledEngines(Paths.get(enginesDirectory, new String[0]));
    }

    public String[] getEnginePathsAsStrings() {
        if (!this.path.toFile().exists()) {
            return new String[0];
        }
        return this.path.toFile().list();
    }

    public File[] getEnginePathsAsFiles() {
        if (!this.path.toFile().exists()) {
            return new File[0];
        }
        return this.path.toFile().listFiles();
    }

    public List<DeepLearningVersion> getAll() {
        if (this.getEnginePathsAsStrings().length == 0) {
            return new ArrayList<DeepLearningVersion>();
        }
        List<DeepLearningVersion> versions = Arrays.stream(this.getEnginePathsAsFiles()).map(t -> {
            try {
                return DeepLearningVersion.fromFile(t);
            }
            catch (Exception e) {
                return null;
            }
        }).filter(v -> v != null && v.checkMissingJars().size() == 0).collect(Collectors.toList());
        return versions;
    }

    public static List<DeepLearningVersion> getAll(String enginesPath) {
        try {
            return InstalledEngines.buildEnginesFinder(enginesPath).getAll();
        }
        catch (IOException ex) {
            return new ArrayList<DeepLearningVersion>();
        }
    }

    public List<DeepLearningVersion> getDownloadedForFramework(String framework) {
        String searchEngine = AvailableEngines.getSupportedFrameworkTag(framework);
        if (searchEngine == null) {
            return new ArrayList<DeepLearningVersion>();
        }
        return this.getDownloadedForOS().stream().filter(v -> searchEngine.contains(v.getFramework().toLowerCase())).collect(Collectors.toList());
    }

    public List<DeepLearningVersion> getDownloadedForVersionedFramework(String framework, String version) {
        String searchEngine = AvailableEngines.getSupportedFrameworkTag(framework);
        if (searchEngine == null) {
            return new ArrayList<DeepLearningVersion>();
        }
        return this.checkEngineWithArgsInstalledForOS(framework, version, null, null);
    }

    public static List<DeepLearningVersion> getDownloadedForFramework(String enginesPath, String framework) {
        try {
            return InstalledEngines.buildEnginesFinder(enginesPath).getDownloadedForFramework(framework);
        }
        catch (IOException ex) {
            return new ArrayList<DeepLearningVersion>();
        }
    }

    public List<DeepLearningVersion> getDownloadedForOS() {
        String currentPlatform = new PlatformDetection().toString();
        boolean rosetta = PlatformDetection.isUsingRosseta();
        int javaVersion = PlatformDetection.getJavaVersion();
        List<DeepLearningVersion> versions = this.getAll();
        versions = versions.stream().filter(v -> v.getOs().equals(currentPlatform) && javaVersion >= v.getMinJavaVersion() && (!rosetta || rosetta && v.getRosetta())).collect(Collectors.toList());
        return versions;
    }

    public static List<DeepLearningVersion> getDownloadedForOS(String enginesPath) {
        try {
            return InstalledEngines.buildEnginesFinder(enginesPath).getDownloadedForOS();
        }
        catch (IOException ex) {
            return new ArrayList<DeepLearningVersion>();
        }
    }

    public List<String> getDownloadedPythonVersionsForFramework(String framework) {
        return this.getDownloadedForFramework(framework).stream().map(DeepLearningVersion::getPythonVersion).collect(Collectors.toList());
    }

    public static List<String> getDownloadedPythonVersionsForFramework(String enginesPath, String framework) {
        try {
            return InstalledEngines.buildEnginesFinder(enginesPath).getDownloadedPythonVersionsForFramework(framework);
        }
        catch (IOException ex) {
            return new ArrayList<String>();
        }
    }

    public static String getEnginesDir() {
        return Paths.get(ENGINES_FOLDER_NAME, new String[0]).toAbsolutePath().toString();
    }

    public static void setEnginesDirectory(String dir) throws IOException {
        if (!new File(dir).isDirectory()) {
            throw new IOException("The engines directory must correspond to an already existing folder. The provided path is not  valid: " + dir);
        }
        ENGINES_FOLDER_NAME = dir;
    }

    public String getMostCompatibleVersionForFramework(String framework, String version) {
        List<String> downloadedVersions = this.getDownloadedPythonVersionsForFramework(framework);
        return VersionStringUtils.getMostCompatibleEngineVersion(version, downloadedVersions, framework);
    }

    public static String getMostCompatibleVersionForFramework(String framework, String version, String enginesDir) {
        try {
            InstalledEngines installed = InstalledEngines.buildEnginesFinder(enginesDir);
            List<String> downloadedVersions = installed.getDownloadedPythonVersionsForFramework(framework);
            return VersionStringUtils.getMostCompatibleEngineVersion(version, downloadedVersions, framework);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static List<String> getOrderedListOfCompatibleVesionsForFramework(String framework, String version, String enginesDir) {
        try {
            InstalledEngines installed = InstalledEngines.buildEnginesFinder(enginesDir);
            List<String> downloadedVersions = installed.getDownloadedPythonVersionsForFramework(framework);
            return VersionStringUtils.getCompatibleEngineVersionsInOrder(version, downloadedVersions, framework);
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean checkFrameworkVersionInstalled(String framework, String version) {
        List<String> downloadedVersions = this.getDownloadedPythonVersionsForFramework(framework);
        String v = downloadedVersions.stream().filter(vv -> vv.equals(version)).findFirst().orElse(null);
        return v != null;
    }

    public static boolean checkFrameworkVersionInstalled(String framework, String version, String enginesDir) {
        try {
            InstalledEngines installed = InstalledEngines.buildEnginesFinder(enginesDir);
            return installed.checkFrameworkVersionInstalled(framework, version);
        }
        catch (IOException e) {
            return false;
        }
    }

    public List<DeepLearningVersion> checkEngineWithArgsInstalled(String framework, String version, Boolean cpu, Boolean gpu, Boolean rosetta, Integer minJavaVersion) {
        String searchEngine = framework != null ? AvailableEngines.getSupportedFrameworkTag(framework) : null;
        if (searchEngine == null && framework != null) {
            return new ArrayList<DeepLearningVersion>();
        }
        String javaVersion = version != null ? SupportedVersions.getJavaVersionForPythonVersion(searchEngine, version) : null;
        List<DeepLearningVersion> filtered = this.getDownloadedForOS().stream().filter(vv -> {
            if (searchEngine != null && !vv.getFramework().toLowerCase().equals(searchEngine)) {
                return false;
            }
            if (javaVersion != null && !vv.getVersion().toLowerCase().equals(javaVersion.toLowerCase())) {
                return false;
            }
            if (cpu != null && vv.getCPU() != cpu.booleanValue()) {
                return false;
            }
            if (gpu != null && vv.getGPU() != gpu.booleanValue()) {
                return false;
            }
            if (minJavaVersion != null && vv.getMinJavaVersion() > minJavaVersion) {
                return false;
            }
            return rosetta == null || rosetta != true || vv.getRosetta() == rosetta.booleanValue();
        }).collect(Collectors.toList());
        return filtered;
    }

    public static List<DeepLearningVersion> checkEngineWithArgsInstalled(String framework, String version, Boolean cpu, Boolean gpu, Boolean rosetta, Integer minJavaVersion, String enginesDir) {
        Objects.requireNonNull(enginesDir);
        try {
            InstalledEngines installed = InstalledEngines.buildEnginesFinder(enginesDir);
            return installed.checkEngineWithArgsInstalled(framework, version, cpu, gpu, rosetta, minJavaVersion);
        }
        catch (IOException e) {
            return new ArrayList<DeepLearningVersion>();
        }
    }

    public List<DeepLearningVersion> checkEngineWithArgsInstalledForOS(String framework, String version, Boolean cpu, Boolean gpu) {
        int javaVersion = PlatformDetection.getJavaVersion();
        boolean rosetta = PlatformDetection.isUsingRosseta();
        return this.checkEngineWithArgsInstalled(framework, version, cpu, gpu, rosetta, javaVersion);
    }

    public static List<DeepLearningVersion> checkEngineWithArgsInstalledForOS(String framework, String version, Boolean cpu, Boolean gpu, String enginesDir) {
        Objects.requireNonNull(enginesDir);
        try {
            InstalledEngines installed = InstalledEngines.buildEnginesFinder(enginesDir);
            return installed.checkEngineWithArgsInstalledForOS(framework, version, cpu, gpu);
        }
        catch (IOException e) {
            return new ArrayList<DeepLearningVersion>();
        }
    }
}

